/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.api.containers;

import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExtensibleElements;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class ContainersImpl<E extends TExtensibleElements> extends BPELElementImpl<E> implements Containers {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public ContainersImpl(final QName tag, final E model, final BPELElement parent) {
		super(tag, model, parent);
	}
	

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new XmlException("Not yet implemented");
	}

	@Override
	public Map<QName, String> getOtherAttributes() throws XmlException {
		return this.model.getOtherAttributes();
	}
}
