/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.exception;

import javax.xml.namespace.QName;

import org.jdom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SOAPAdapter;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class UserDefinedException extends BPELException {

	public static enum FaultQnameType { ELEMENT_QNAME, MESSAGE_QNAME };
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private final Scope scope;
	
	private final QName faultName;
	
	private final String faultVariableName;
	
	private final FaultQnameType qnameType;
	
	private final QName qname;
	
	public UserDefinedException(final QName faultName, final String faultVariable,
			final FaultQnameType qnameType,
			final QName qname,
			final Scope scope) {
		this.scope = scope;
		this.faultName = faultName;
		this.setName(this.faultName.toString());
		this.faultVariableName = faultVariable;
		this.qnameType = qnameType;
		this.qname = qname;
	}
	
	
	public Scope getScope() {
		return this.scope;
	}


	public QName getFaultName() {
		return this.faultName;
	}


	public String getFaultVariableName() {
		return this.faultVariableName;
	}


	public FaultQnameType getQnameType() {
		return qnameType;
	}


	public QName getQname() {
		return qname;
	}

	
	public void resolveFaultMessage() throws CoreException {
		if (getFault() != null) return;
		Variable faultVariable = scope.findVariable(new QName(faultVariableName));
		if (faultVariable == null) {
			// TODO : one could use a a constant builtin exception name instead of providing
			// a variable name ; unsupported right now.
			throw new CoreException("Variable " + faultVariableName + " cannot be found!");
		}
		// FIXME : by default, we create a SOAPFault 1.1 which is not fair ; 
		// we should create SOAPFault at a higher level where SOAP binding version is known.
		if (faultVariable.getValue() == null) return;
		
		Element soapFaultRootElement = (Element) faultVariable.getValue().getContent();
		Element soapFault = SOAPAdapter.createSOAPFault((Element) soapFaultRootElement.getChildren().get(0));
		BPELInternalMessage message = new BPELInternalMessageImpl();
		message.setContent(soapFault);
		setFault(message);
	}
	
}
