/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.tools;

import java.net.URI;
import java.net.URL;

public class URLUtil {

	/**
	 * Builds an URI from an URL (with an handle for URLs not compliant with RFC 2396).
	 * @param url
	 * @return
	 */
	public static URI urlToUri( final URL url ) {

	URI uri;
	try {
	// Possible failing step.
	uri = url.toURI();
	} catch( final Exception e ) {
	// URL did not comply with RFC 2396 => illegal un-escaped characters.
	try {
	uri = new URI(
	url.getProtocol(), url.getUserInfo(),
	url.getHost(), url.getPort(),
	url.getPath(), url.getQuery(), url.getRef());
	} catch( final Exception e1 ) {
	// No automatic repair.
	throw new IllegalArgumentException( "Broken URL: " + url );
	}
	}

	uri = uri.normalize();
	return uri;
	}
}
