/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Query;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.QueryValidator;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;

public class QueryValidatorImpl implements QueryValidator {

	private Query query = null;

	public QueryValidatorImpl(final Query query) {
		this.query = query;
	}

	public void validate() {
		// validation
		if((this.query.getQueryLanguage() != null) && !this.query.getQueryLanguage().toString().equals("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0")
				&& !this.query.getQueryLanguage().toString().equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
			BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.query, new BPELException("In expressionLanguage => Unknowned uri: " + this.query.getQueryLanguage() + ". Only the uri " + "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0" + " and " + "http://www.w3.org/TR/1999/REC-xpath-19991116"+ " are supported")));
		}
	}

}
