/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BuiltInException extends BPELException {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Exception name
	 */
	public static String AMBIGUOUS_RECEIVE="ambiguousReceive";
	public static String COMPLETION_CONDITION_FAILURE="completionConditionFailure";
	public static String CONFLICTING_RECEIVE="conflictingReceive";
	public static String CONFLICTING_REQUEST="conflictingRequest";
	public static String CORRELATION_VIOLATION="correlationViolation";
	public static String INVALID_BRANCH_CONDITION="invalidBranchCondition";
	public static String INVALID_EXPRESSION_VALUE="invalidExpressionValue";
	public static String INVALID_VARIABLES="invalidVariables";
	public static String JOIN_FAILURE="joinFailure";
	public static String MISMATCHED_ASSIGNEMENT_FAILURE="mismatchedAssignmentFailure";
	public static String MISSING_REPLY="missingReply";
	public static String MISSING_REQUEST="missingRequest";
	public static String SCOPE_INITIALIZATION_FAILURE="scopeInitializationFailure";
	public static String SELECTION_FAILURE="selectionFailure";
	public static String SUB_LANGUAGE_EXECUTION_FAULT="subLanguageExecutionFault";
	public static String UNINITIALIZED_PARTNER_ROLE="uninitializedPartnerRole";
	public static String UNINITIALIZED_VARIABLE="uninitialzedVariable";
	public static String UNSUPPORTED_REFERENCE="unsupportedReference";
	public static String XSLT_INVALID_SOURCE="xsltInvalidSource";
	public static String XSLT_STYLESHEET_NOT_FOUND="xsltStylesheetNotFound";
	
	
	private static final List<BuiltInException> buildinExceptions = new ArrayList<BuiltInException>(Arrays
			.asList(new BuiltInException[] { 
					new AmbiguousReceiveException(), 
					new CompletionConditionException(),
					new ConflictingReceiveException(),
					new ConflictingRequestException(),
					new InvalidBranchConditionException(),
					new InvalidVariablesException(), 
					new JoinFailureException(), 
					new MismatchedAssignementFailureException(), 
					new MissingReplyException(),
					new MissingRequestException(),
					new ScopeInitializationFailureException(),
					new SelectionFailureException(),
					new SubLanguageExecutionFaultException(),
					new UninitializedPartnerRoleException(),
					new UninitializedVariableException(),
					new UnsupportedReferenceException(),
					new XsltInvalidSourceException(),
					new XsltStyleSheetNotFoundException()}));

	
	public BuiltInException() {
		super();
	}

	
	public BuiltInException(final String msg) {
		super(msg);
	}
	
	public BuiltInException(final String msg, final Throwable t) {
		super(msg, t);
	}


	@Override
	public void setName(final String name) {
		super.setName(new QName(Constants.BPEL_20_EXECUTABLE_NAMESPACE, name).toString());
	}
	
	public static BuiltInException valueOfBPELBuiltInExceptionFrom(final String val) {
		BuiltInException res = null;
		for(final BuiltInException bpel: buildinExceptions) {
			if(QName.valueOf(bpel.getName()).getLocalPart().equals(val)) {
				res = bpel;
				break;
			}
		}
		return res;
	}
}
