/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;

import org.apache.commons.lang.NotImplementedException;
import org.jdom.Element;
import org.ow2.easywsdl.schema.api.XmlException;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELBooleanExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ParseException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELBooleanExpressionImpl extends BPELExpressionImpl<Boolean> implements BPELBooleanExpression {


	private Logger log = Logger.getLogger(BPELBooleanExpressionImpl.class.getName());


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private BPELProcess bpeldefinition;

	public BPELBooleanExpressionImpl(final TExpression model, final BPELElement parent) throws XPathExpressionException {
		super(model, parent);
		this.bpeldefinition = ScopeUtil.getProcess(parent);
	}

	public Boolean evaluate(final Scope scope) throws CoreException {
		Boolean res = null;
		String booleanExpression = "";
		if(this.getContent() != null) {
			booleanExpression = this.getContent();
		}
		try {
			this.log.finest("boolean expression to evaluate: " + booleanExpression);
//			final InputStream input = new ByteArrayInputStream(booleanExpression.getBytes());
			final ExpressionAnalyzer analyzer = new ExpressionAnalyzer(booleanExpression);
			final ASTStart n = analyzer.Start();
			final ExpressionVisitor v = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
			if(!this.log.getName().equals(BPELBooleanExpressionImpl.class.getName())) {
				((ExpressionDumpVisitor)v).setLog(this.log);
			}
			final Object result = n.jjtAccept(v, null);
			if(result instanceof BPELException) {
				throw (BPELException)result;
			} else if(result instanceof Element) {
				final Element elmt = (Element)result; 
				res = Boolean.parseBoolean(elmt.getText());
			} else {
				throw new BPELException("result unknown");
			}
		} catch (final BPELException e) {
			throw new CoreException("Impossible to evaluate expression: " + booleanExpression, e);
		} catch (final ParseException e) {
			throw new CoreException("Impossible to evaluate expression: " + booleanExpression, e);
		}
		return res;
	}

	public BPELProcess getBpeldefinition() {
		return this.bpeldefinition;
	}

	public void setBpeldefinition(final BPELProcess bpeldefinition) {
		this.bpeldefinition = bpeldefinition;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

	public Expression<String, Boolean> copypaste() {
		BPELBooleanExpression exp = null;
		try {
			exp = new BPELBooleanExpressionImpl(this.getModel(), (BPELElement) this.getParent());
		} catch (XPathExpressionException e) {
			// do nothing
		}
		return exp;
	}

	public void addOtherElements(org.w3c.dom.Element elmt) {
		throw new NotImplementedException();
	}

	public List<org.w3c.dom.Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

}
