package com.ebmwebsourcing.easybpmn.bpmn20.api;

/**
 * Enumeration of the supported import types
 * @author gcrosmarie
 *
 */
public enum ImportType {

	XSD("http://www.w3.org/2001/XMLSchema"),
    WSDL20("http://www.w3.org/TR/wsdl20"),
    BPMN20("http://www.omg.org/spec/BPMN/20100524/MODEL"),
    WSDL11("http://schemas.xmlsoap.org/wsdl");
	
	private String value;
	
	private ImportType(String value){
		this.value = value;
	}
    
	public static ImportType fromValue(String s){
		if(s.endsWith("/")){
			s = s.substring(0, s.length()-1);
		}
		for(ImportType it : values()){
			if(it.value.equals(s)){
				return it;
			}
		}
		return null;
	}
	
	public String getValue(){
		return value;
	}
	
}
