/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TComplexGateway;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTComplexGateway;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExpression;

class TComplexGatewayImpl extends
		AbstractTGatewayImpl<EJaxbTComplexGateway> implements
		TComplexGateway {

	protected TComplexGatewayImpl(XmlContext xmlContext,
			EJaxbTComplexGateway jaxbModel) {
		super(xmlContext, jaxbModel);

	}

	@Override
	public Expression getActivationCondition() {
		return (Expression)
				this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getActivationCondition());
	}

	@Override
	public void setActivationCondition(Expression value) {
		if(value!=null){
			this.getModelObject().setActivationCondition((EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
		}
		else{
			this.getModelObject().setActivationCondition(null);
		}
	}

	@Override
	public boolean hasActivationCondition() {
		return this.getModelObject().isSetActivationCondition();
	}

	@Override
	public SequenceFlow getDefault() {
		if(this.getModelObject().getDefault()!=null){
			return (SequenceFlow) getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getDefault());
		}
		return null;
	}

	@Override
	public void setDefault(SequenceFlow value) {
		if(value==null){
			this.getModelObject().setDefault(null);
		}
		else{
			this.getModelObject().setDefault(((TSequenceFlowImpl)value).getModelObject());
		}
	}

	@Override
	public boolean hasDefault() {
		return this.getModelObject().isSetDefault();
	}

	@Override
	protected Class<? extends EJaxbTComplexGateway> getCompliantModelClass() {
		return EJaxbTComplexGateway.class;
	}


}
