/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TConversationAssociation;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTConversationAssociation;

class TConversationAssociationImpl extends
		AbstractTBaseElementImpl<EJaxbTConversationAssociation> implements
		TConversationAssociation {

	protected TConversationAssociationImpl(XmlContext xmlContext,
			EJaxbTConversationAssociation jaxbModel) {
		super(xmlContext, jaxbModel);

	}

	@Override
	public QName getInnerConversationNodeRef() {
		return this.getModelObject().getInnerConversationNodeRef();
	}

	@Override
	public void setInnerConversationNodeRef(QName value) {
		this.getModelObject().setInnerConversationNodeRef(value);
	}

	@Override
	public boolean hasInnerConversationNodeRef() {
		return this.getModelObject().isSetInnerConversationNodeRef();
	}

	@Override
	public QName getOuterConversationNodeRef() {
		return this.getModelObject().getOuterConversationNodeRef();
	}

	@Override
	public void setOuterConversationNodeRef(QName value) {
		this.getModelObject().setOuterConversationNodeRef(value);
	}

	@Override
	public boolean hasOuterConversationNodeRef() {
		return this.getModelObject().isSetOuterConversationNodeRef();
	}

	@Override
	protected Class<? extends EJaxbTConversationAssociation> getCompliantModelClass() {
		return EJaxbTConversationAssociation.class;
	}

}
