/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Script;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TGlobalScriptTask;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTGlobalScriptTask;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTScript;

class TGlobalScriptTaskImpl extends
		TGlobalTaskImpl implements
		TGlobalScriptTask {

	protected TGlobalScriptTaskImpl(XmlContext xmlContext,
			EJaxbTGlobalScriptTask jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public EJaxbTGlobalScriptTask getModelObject() {
		return (EJaxbTGlobalScriptTask)super.getModelObject();
	}
	
	@Override
	public Script getScript() {
		return this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getScript(),ScriptImpl.class);
	}

	@Override
	public void setScript(Script value) {
		this.getModelObject().setScript((EJaxbTScript) value);
	}

	@Override
	public boolean hasScript() {
		return this.getModelObject().isSetScript();
	}

	@Override
	public String getScriptLanguage() {
		return this.getModelObject().getScriptLanguage();
	}

	@Override
	public void setScriptLanguage(String value) {
		this.getModelObject().setScriptLanguage(value);
	}

	@Override
	public boolean hasScriptLanguage() {
		return this.getModelObject().isSetScriptLanguage();
	}

	@Override
	protected Class<? extends EJaxbTGlobalScriptTask> getCompliantModelClass() {
		return EJaxbTGlobalScriptTask.class;
	}

}
