/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TInputSet;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataInput;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTInputSet;

class TInputSetImpl extends AbstractTBaseElementImpl<EJaxbTInputSet> implements
		TInputSet {

	protected TInputSetImpl(XmlContext xmlContext, EJaxbTInputSet jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public DataInput[] getDataInputRefs() {
		XmlObject[] tab = createChildrenArray(getModelObject().getDataInputRefs(), EJaxbTDataInput.class, ANY_QNAME);
		DataInput[] res = new DataInput[tab.length];
		for(int i=0; i<tab.length; i++){
		    res[i] = (DataInput) tab[i];
		}
		return res;
	}
	
	@Override
	public void addDataInputRef(DataInput di) {
	    addToChildren(getModelObject().getDataInputRefs(), di);
	}

	@Override
	public void removeDataInputRef(DataInput di) {
	    removeFromChildren(getModelObject().getDataInputRefs(), di);
	}

	@Override
	public boolean hastDataInputRefs() {
		return this.getModelObject().isSetDataInputRefs();
	}

	@Override
	public void unsetDataInputRefs() {
		this.getModelObject().unsetDataInputRefs();
	}

	@Override
	public Object[] getOptionalInputRefs() {
		return this.getModelObject().getOptionalInputRefs().toArray();
	}

	@Override
	public boolean hasOptionalInputRefs() {
		return this.getModelObject().isSetOptionalInputRefs();
	}

	@Override
	public void unsetOptionalInputRefs() {
		this.getModelObject().unsetOptionalInputRefs();
	}

	@Override
	public Object[] getWhileExecutingInputRefs() {
		return this.getModelObject().getWhileExecutingInputRefs().toArray();
	}

	@Override
	public boolean hasWhileExecutingInputRefs() {
		return this.getModelObject().isSetWhileExecutingInputRefs();
	}

	@Override
	public void unsetWhileExecutingInputRefs() {
		this.getModelObject().unsetWhileExecutingInputRefs();

	}

	@Override
	public Object[] getOutputSetRefs() {
		return this.getModelObject().getOutputSetRefs().toArray();
	}

	@Override
	public boolean hasOutputSetRefs() {
		return this.getModelObject().isSetOutputSetRefs();
	}

	@Override
	public void unsetOutputSetRefs() {
		this.getModelObject().unsetOutputSetRefs();

	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);

	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
	protected Class<? extends EJaxbTInputSet> getCompliantModelClass() {
		return EJaxbTInputSet.class;
	}

}
