/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.bind.JAXBElement;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataOutput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TOutputSet;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataOutput;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTOutputSet;

public class TOutputSetImpl extends AbstractTBaseElementImpl<EJaxbTOutputSet>
		implements TOutputSet {

	protected TOutputSetImpl(XmlContext xmlContext, EJaxbTOutputSet jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
    public DataOutput[] getDataOutputRefs() {
        XmlObject[] tab = createChildrenArray(getModelObject().getDataOutputRefs(), EJaxbTDataOutput.class, ANY_QNAME);
        DataOutput[] res = new DataOutput[tab.length];
        for(int i=0; i<tab.length; i++){
            res[i] = (DataOutput) tab[i];
        }
        return res;
    }
    
    @Override
    public void addDataOutputRef(DataOutput di) {
        addToChildren(getModelObject().getDataOutputRefs(), di);
    }

    @Override
    public void removeDataOutputRef(DataOutput di) {
        removeFromChildren(getModelObject().getDataOutputRefs(), di);
    }

	@Override
	public boolean isSetDataOutputRefs() {
		return this.getModelObject().isSetDataOutputRefs();
	}

	@Override
	public void unsetDataOutputRefs() {
		this.getModelObject().unsetDataOutputRefs();
	}

	@Override
	public Object[] getOptionalOutputRefs() {
		if(this.getModelObject().getOptionalOutputRefs()==null){
			return null;
		}
		Object[] result = new Object[this.getModelObject().getOptionalOutputRefs().size()];
		int i = 0;
		for(JAXBElement<Object> e : this.getModelObject().getOptionalOutputRefs()){
			result[i] = e.getValue();
			i++;
		}
		return result;
	}

	@Override
	public boolean hasOptionalOutputRefs() {
		return this.getModelObject().isSetOptionalOutputRefs();
	}

	@Override
	public void unsetOptionalOutputRefs() {
		this.getModelObject().unsetOptionalOutputRefs();

	}

	@Override
	public Object[] getWhileExecutingOutputRefs() {
		if(this.getModelObject().getWhileExecutingOutputRefs()==null){
			return null;
		}
		Object[] result = new Object[this.getModelObject().getWhileExecutingOutputRefs().size()];
		int i = 0;
		for(JAXBElement<Object> e : this.getModelObject().getWhileExecutingOutputRefs()){
			result[i] = e.getValue();
			i++;
		}
		return result;
	}

	@Override
	public boolean hasWhileExecutingOutputRefs() {
		return this.getModelObject().isSetWhileExecutingOutputRefs();
	}

	@Override
	public void unsetWhileExecutingOutputRefs() {
		this.getModelObject().unsetWhileExecutingOutputRefs();

	}

	@Override
	public Object[] getInputSetRefs() {
		if(this.getModelObject().getInputSetRefs()==null){
			return null;
		}
		Object[] result = new Object[this.getModelObject().getInputSetRefs().size()];
		int i = 0;
		for(JAXBElement<Object> e : this.getModelObject().getInputSetRefs()){
			result[i] = e.getValue();
			i++;
		}
		return result;
	}

	@Override
	public boolean hasInputSetRefs() {
		return this.getModelObject().isSetInputSetRefs();
	}

	@Override
	public void unsetInputSetRefs() {
		this.getModelObject().unsetInputSetRefs();

	}

	@Override
	protected Class<? extends EJaxbTOutputSet> getCompliantModelClass() {
		return EJaxbTOutputSet.class;
	}
}
