/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TAdHocOrdering;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TAdHocSubProcess;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTAdHocOrdering;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTAdHocSubProcess;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExpression;

public class TAdHocSubProcessImpl extends
TSubProcessImpl implements TAdHocSubProcess {
	
	protected TAdHocSubProcessImpl(XmlContext xmlContext,
			EJaxbTAdHocSubProcess jaxbModel) {
		super(xmlContext, jaxbModel);
	}
	
	@Override
	public EJaxbTAdHocSubProcess getModelObject() {
		return (EJaxbTAdHocSubProcess) super.getModelObject();
	}
	
	@Override
	protected Class<? extends EJaxbTAdHocSubProcess> getCompliantModelClass() {
		return EJaxbTAdHocSubProcess.class;
	}

	@Override
	public Expression getCompletionCondition() {
		if (this.getModelObject().getCompletionCondition() != null) {
			return (Expression) this
					.getXmlContext()
					.getXmlObjectFactory()
					.wrap(this.getModelObject().getCompletionCondition());
		}
		return null;
	}

	@Override
	public void setCompletionCondition(Expression value) {
		this.getModelObject().setCompletionCondition((EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
	}

	@Override
	public boolean hasCompletionCondition() {
		return this.getModelObject().isSetCompletionCondition();
	}

	@Override
	public boolean isCancelRemainingInstances() {
		return this.getModelObject().isCancelRemainingInstances();
	}

	@Override
	public void setCancelRemainingInstances(boolean value) {
		this.getModelObject().setCancelRemainingInstances(value);

	}

	@Override
	public boolean hasCancelRemainingInstances() {
		return this.getModelObject().isCancelRemainingInstances();
	}

	@Override
	public void unsetCancelRemainingInstances() {
		this.getModelObject().unsetCancelRemainingInstances();

	}

	@Override
	public TAdHocOrdering getOrdering() {
		if (getModelObject().getOrdering() == null)
			return null;
		return TAdHocOrdering.valueOf(getModelObject().getOrdering().toString()
				.toUpperCase());
	}

	@Override
	public void setOrdering(TAdHocOrdering value) {
		if (value == null) {
			getModelObject().setOrdering(null);
		} else if (value.equals(TAdHocOrdering.Parallel)) {
			getModelObject().setOrdering(EJaxbTAdHocOrdering.PARALLEL);
		} else if (value.equals(TAdHocOrdering.Sequential)) {
			getModelObject().setOrdering(EJaxbTAdHocOrdering.SEQUENTIAL);
		}
	}

	@Override
	public boolean isSetOrdering() {
		return this.getModelObject().isSetOrdering();
	}

}
