/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TAssociationDirection;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTAssociation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTAssociationDirection;

class TAssociationImpl extends AbstractTArtifactImpl<EJaxbTAssociation>
		implements TAssociation {

	protected TAssociationImpl(XmlContext xmlContext,
			EJaxbTAssociation jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public QName getSourceRef() {
		return this.getModelObject().getSourceRef();
	}

	@Override
	public void setSourceRef(QName value) {
		if (value != null) {
			this.getModelObject().setSourceRef(value);
		}
	}

	@Override
	public boolean hasSourceRef() {
		return this.getModelObject().isSetSourceRef();
	}

	@Override
	public QName getTargetRef() {
		return this.getModelObject().getTargetRef();
	}

	@Override
	public void setTargetRef(QName value) {
		if (value != null) {
			this.getModelObject().setTargetRef(value);
		}

	}

	@Override
	public boolean hasTargetRef() {
		return this.getModelObject().isSetTargetRef();
	}

	@Override
	public TAssociationDirection getAssociationDirection() {
		if (getModelObject().getAssociationDirection() == null){
			return null;
		}
		TAssociationDirection result = null;
		switch(this.getModelObject().getAssociationDirection()){
		case BOTH:
			result = TAssociationDirection.Both;
			break;
		case NONE:
			result = TAssociationDirection.None;
			break;
		case ONE:
			result = TAssociationDirection.One;
			break;
		}
		return result;
	}

	@Override
	public void setAssociationDirection(TAssociationDirection value) {
		if (value == null) {
			this.getModelObject().setAssociationDirection(null);
		} else if (value.equals(TAssociationDirection.Both)) {
			getModelObject().setAssociationDirection(
					EJaxbTAssociationDirection.BOTH);
		} else if (value.equals(TAssociationDirection.None)) {
			getModelObject().setAssociationDirection(
					EJaxbTAssociationDirection.NONE);
		} else {
			getModelObject().setAssociationDirection(
					EJaxbTAssociationDirection.ONE);
		}
	}

	@Override
	public boolean hasAssociationDirection() {
		return getModelObject().isSetAssociationDirection();
	}

	@Override
	protected Class<? extends EJaxbTAssociation> getCompliantModelClass() {
		return EJaxbTAssociation.class;
	}

}
