/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ParticipantAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TCallConversation;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCallConversation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTParticipantAssociation;

class TCallConversationImpl extends AbstractTConversationNodeImpl<EJaxbTCallConversation>
		implements TCallConversation {

	protected TCallConversationImpl(XmlContext xmlContext,
			EJaxbTCallConversation jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTCallConversation> getCompliantModelClass() {
		return EJaxbTCallConversation.class;
	}

	@Override
	public ParticipantAssociation[] getParticipantAssociation() {
		return createChildrenArray(getModelObject().getParticipantAssociation(),
				EJaxbTParticipantAssociation.class, ANY_QNAME, ParticipantAssociation.class);  
	}

	@Override
	public boolean hasParticipantAssociation() {
		return this.getModelObject().isSetParticipantAssociation();
	}

	@Override
	public void unsetParticipantAssociation() {
		this.getModelObject().unsetParticipantAssociation();
	}

	@Override
	public QName getCalledCollaborationRef() {
		return this.getModelObject().getCalledCollaborationRef();
	}

	@Override
	public void setCalledCollaborationRef(QName value) {
		this.getModelObject().setCalledCollaborationRef(value);
	}

	@Override
	public boolean hasCalledCollaborationRef() {
		return this.getModelObject().isSetCalledCollaborationRef();
	}

}
