/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TCompensateEventDefinition;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCompensateEventDefinition;

class TCompensateEventDefinitionImpl extends
		AbstractTEventDefinitionImpl<EJaxbTCompensateEventDefinition> implements
		TCompensateEventDefinition {

	protected TCompensateEventDefinitionImpl(XmlContext xmlContext,
			EJaxbTCompensateEventDefinition jaxbModel) {
		super(xmlContext, jaxbModel);

	}

	@Override
	public boolean isWaitForCompletion() {
		if(hasWaitForCompletion()){
			return this.getModelObject().isSetWaitForCompletion();
		}
		else{
			return false;
		}
	}

	@Override
	public void setWaitForCompletion(boolean value) {
		this.getModelObject().setWaitForCompletion(value);
	}

	@Override
	public boolean hasWaitForCompletion() {
		return this.getModelObject().isSetWaitForCompletion();
	}

	@Override
	public void unsetWaitForCompletion() {
		this.getModelObject().unsetWaitForCompletion();
	}

	@Override
	public QName getActivityRef() {
		return this.getModelObject().getActivityRef();
	}

	@Override
	public void setActivityRef(QName value) {
		this.getModelObject().setActivityRef(value);
	}

	@Override
	public boolean hasActivityRef() {
		return this.getModelObject().isSetActivityRef();
	}

	@Override
	protected Class<? extends EJaxbTCompensateEventDefinition> getCompliantModelClass() {
		return EJaxbTCompensateEventDefinition.class;
	}

}
