/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CorrelationPropertyBinding;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TCorrelationSubscription;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCorrelationPropertyBinding;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCorrelationSubscription;

class TCorrelationSubscriptionImpl extends
AbstractTBaseElementImpl<EJaxbTCorrelationSubscription> implements
TCorrelationSubscription {

	protected TCorrelationSubscriptionImpl(XmlContext xmlContext,
			EJaxbTCorrelationSubscription jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbTCorrelationSubscription> getCompliantModelClass() {
		return EJaxbTCorrelationSubscription.class;
	}

	@Override
	public CorrelationPropertyBinding[] getCorrelationPropertyBinding() {
		return  createChildrenArray(getModelObject().getCorrelationPropertyBinding(),
				EJaxbTCorrelationPropertyBinding.class, ANY_QNAME,
				CorrelationPropertyBindingImpl.class);
	}

	@Override
	public boolean hasCorrelationPropertyBinding() {
		return this.getModelObject().isSetCorrelationPropertyBinding();
	}

	@Override
	public void unsetCorrelationPropertyBinding() {
		this.getModelObject().unsetCorrelationPropertyBinding();
	}

	@Override
	public QName getCorrelationKeyRef() {
		return this.getModelObject().getCorrelationKeyRef();
	}

	@Override
	public void setCorrelationKeyRef(QName value) {
		this.getModelObject().setCorrelationKeyRef(value);
	}

	@Override
	public boolean hasCorrelationKeyRef() {
		return this.getModelObject().isSetCorrelationKeyRef();
	}



}
