/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TError;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTError;

class TErrorImpl extends AbstractTRootElementImpl<EJaxbTError> implements
		TError {

	protected TErrorImpl(XmlContext xmlContext, EJaxbTError jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
	public String getErrorCode() {
		return this.getModelObject().getErrorCode();
	}

	@Override
	public void setErrorCode(String value) {
		this.getModelObject().setErrorCode(value);
	}

	@Override
	public boolean hasErrorCode() {
		return this.getModelObject().isSetErrorCode();
	}

	@Override
	public QName getStructureRef() {
		return this.getModelObject().getStructureRef();
	}

	@Override
	public void setStructureRef(QName value) {
		this.getModelObject().setStructureRef(value);
	}

	@Override
	public boolean hasStructureRef() {
		return this.getModelObject().isSetStructureRef();
	}

	@Override
	protected Class<? extends EJaxbTError> getCompliantModelClass() {
		return EJaxbTError.class;
	}

}
