/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TExpression;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExpression;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFormalExpression;

class TExpressionImpl extends AbstractTBaseElementWithMixedContentImpl<EJaxbTExpression>
		implements TExpression {

	protected TExpressionImpl(XmlContext xmlContext, EJaxbTExpression jaxbModel) {
	    super(xmlContext,jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTExpression> getCompliantModelClass() {
		return EJaxbTFormalExpression.class;
	}

	@Override
    public String getLanguage() {
	    if(getModelObject() instanceof EJaxbTFormalExpression){
	        return ((EJaxbTFormalExpression)this.getModelObject()).getLanguage();
	    }
	    return null;
    }

    @Override
    public void setLanguage(String value) {
        this.setModelObject(getModelObject().duplicateAs(EJaxbTFormalExpression.class));
        ((EJaxbTFormalExpression)this.getModelObject()).setLanguage(value);
    }

    @Override
    public boolean hasLanguage() {
        return this.getModelObject() instanceof EJaxbTFormalExpression &&
            ((EJaxbTFormalExpression)this.getModelObject()).isSetLanguage();
    }

    @Override
    public QName getEvaluatesToTypeRef() {
        if(getModelObject() instanceof EJaxbTFormalExpression){
            return ((EJaxbTFormalExpression)this.getModelObject()).getEvaluatesToTypeRef();
        }
        return null;
    }

    @Override
    public void setEvaluatesToTypeRef(QName value) {
        this.setModelObject(getModelObject().duplicateAs(EJaxbTFormalExpression.class));
        ((EJaxbTFormalExpression)this.getModelObject()).setEvaluatesToTypeRef(value);
    }

    @Override
    public boolean hasEvaluatesToTypeRef() {
        return this.getModelObject() instanceof EJaxbTFormalExpression &&
            ((EJaxbTFormalExpression)this.getModelObject()).isSetEvaluatesToTypeRef();
    }
	
}
