/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ResourceRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TGlobalTask;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTGlobalTask;

class TGlobalTaskImpl extends
		TCallableElementImpl implements
		TGlobalTask {

	protected TGlobalTaskImpl(XmlContext xmlContext,
			EJaxbTGlobalTask jaxbModel) {
		super(xmlContext, jaxbModel);
	}
	
	@Override
	protected Class<? extends EJaxbTGlobalTask> getCompliantModelClass() {
		return EJaxbTGlobalTask.class;
	}
	
	@Override
	public EJaxbTGlobalTask getModelObject() {
		return (EJaxbTGlobalTask) super.getModelObject();
	}

	@Override
	public ResourceRole[] getResourceRole() {
		if (this.getModelObject().getResourceRole() != null) {

		}
		return null;
	}

	@Override
	public boolean hasResourceRole() {
		return this.getModelObject().isSetResourceRole();
	}

	@Override
	public void unsetResourceRole() {
		this.getModelObject().unsetResourceRole();
	}

}
