/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TItemKind;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTItemDefinition;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTItemKind;

class TItemDefinitionImpl extends
		AbstractTRootElementImpl<EJaxbTItemDefinition> implements
		TItemDefinition {

	protected TItemDefinitionImpl(XmlContext xmlContext,
			EJaxbTItemDefinition jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public QName getStructureRef() {
		return this.getModelObject().getStructureRef();
	}

	@Override
	public void setStructureRef(QName value) {
		this.getModelObject().setStructureRef(value);
	}

	@Override
	public boolean hasStructureRef() {
		return this.getModelObject().isSetStructureRef();
	}

	@Override
	public boolean isIsCollection() {
		return this.getModelObject().isIsCollection();
	}

	@Override
	public void setIsCollection(boolean value) {
		this.getModelObject().setIsCollection(value);
	}

	@Override
	public boolean hasIsCollection() {
		return this.getModelObject().isIsCollection();
	}

	@Override
	public void unsetIsCollection() {
		this.getModelObject().unsetIsCollection();
	}

	@Override
	public TItemKind getItemKind() {
		if (getModelObject().getItemKind() == null){
			return null;
		}
		TItemKind result  = null;
		switch(this.getModelObject().getItemKind()){
		case INFORMATION:
			result = TItemKind.Information;
			break;
		case PHYSICAL:
			result = TItemKind.Physical;
			break;
		}
		return result;
	}

	@Override
	public void setItemKind(TItemKind value) {
		if (value == null) {
			this.getModelObject().setItemKind(null);
		} else if (value.equals(TItemKind.Information)) {
			getModelObject().setItemKind(EJaxbTItemKind.INFORMATION);
		} else if (value.equals(TItemKind.Physical)) {
			getModelObject().setItemKind(EJaxbTItemKind.PHYSICAL);
		}
	}

	@Override
	public boolean hasItemKind() {
		return this.getModelObject().isSetItemKind();
	}

	@Override
	protected Class<? extends EJaxbTItemDefinition> getCompliantModelClass() {
		return EJaxbTItemDefinition.class;
	}

}
