/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TResourceParameterBinding;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExpression;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTResourceParameterBinding;

public class TResourceParameterBindingImpl extends
		AbstractTBaseElementImpl<EJaxbTResourceParameterBinding> implements
		TResourceParameterBinding {

	protected TResourceParameterBindingImpl(XmlContext xmlContext,
			EJaxbTResourceParameterBinding jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTResourceParameterBinding> getCompliantModelClass() {
		return EJaxbTResourceParameterBinding.class;
	}

	@Override
	public Expression getExpression() {
		return (Expression) this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getExpression().getValue());
	}

	@Override
	public void setExpression(Expression value) {
		JAXBElement<? extends EJaxbTExpression> e = 
			new JAXBElement<EJaxbTExpression>(Expression.QNAME, EJaxbTExpression.class, (EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
		this.getModelObject().setExpression(e);
	}

	@Override
	public boolean hasExpression() {
		return this.getModelObject().isSetExpression();
	}

	@Override
	public QName getParameterRef() {
		return this.getModelObject().getParameterRef();
	}

	@Override
	public void setParameterRef(QName value) {
		this.getModelObject().setParameterRef(value);

	}

	@Override
	public boolean isSetParameterRef() {
		return this.getModelObject().isSetParameterRef();
	}
}
