/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ResourceAssignmentExpression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ResourceParameterBinding;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TResourceRole;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTResourceParameterBinding;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTResourceRole;

public class TResourceRoleImpl extends
		AbstractTBaseElementImpl<EJaxbTResourceRole> implements TResourceRole {

	protected TResourceRoleImpl(XmlContext xmlContext,
			EJaxbTResourceRole jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTResourceRole> getCompliantModelClass() {
		return EJaxbTResourceRole.class;
	}

	@Override
	public QName getResourceRef() {
		return this.getModelObject().getResourceRef();
	}

	@Override
	public void setResourceRef(QName value) {
		this.getModelObject().setResourceRef(value);
	}

	@Override
	public boolean hasResourceRef() {
		return this.getModelObject().isSetResourceRef();
	}

	@Override
	public ResourceParameterBinding[] getResourceParameterBinding() {
		return createChildrenArray(getModelObject()
				.getResourceParameterBinding(),
				EJaxbTResourceParameterBinding.class, ANY_QNAME,
				ResourceParameterBindingImpl.class);
	}

	@Override
	public boolean hasResourceParameterBinding() {
		return this.getModelObject().isSetResourceParameterBinding();
	}

	@Override
	public void unsetResourceParameterBinding() {
		this.getModelObject().unsetResourceParameterBinding();
	}

	@Override
	public ResourceAssignmentExpression getResourceAssignmentExpression() {
		return this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getResourceAssignmentExpression(),
						ResourceAssignmentExpressionImpl.class);
	}

	@Override
	public void setResourceAssignmentExpression(
			ResourceAssignmentExpression value) {
		this.getModelObject().setResourceAssignmentExpression(
				((ResourceAssignmentExpressionImpl)value).getModelObject());
	}

	@Override
	public boolean hasResourceAssignmentExpression() {
		return this.getModelObject().isSetResourceAssignmentExpression();
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}
}
