/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/

package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Artifact;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TSubChoreography;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTArtifact;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFlowElement;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFlowNode;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTSubChoreography;

class TSubChoreographyImpl extends AbstractTChoreographyActivityImpl<EJaxbTSubChoreography>
        implements TSubChoreography {

    protected TSubChoreographyImpl(XmlContext xmlContext, EJaxbTSubChoreography jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTSubChoreography> getCompliantModelClass() {
        return EJaxbTSubChoreography.class;
    }

    @Override
    public FlowElement[] getFlowElement() {
        XmlObject[] tab = createChildrenArray(getModelObject().getFlowElement(),
                EJaxbTFlowElement.class, ANY_QNAME);
        FlowElement[] result = new FlowElement[tab.length];
        for (int i = 0; i < tab.length; i++) {
            result[i] = (FlowElement) tab[i];
        }
        return result;
    }

    @Override
    public FlowNode[] getFlowNode() {
        XmlObject[] tab = createChildrenArray(getModelObject().getFlowElement(),
                EJaxbTFlowNode.class, ANY_QNAME);
        FlowNode[] result = new FlowNode[tab.length];
        for (int i = 0; i < tab.length; i++) {
            result[i] = (FlowNode) tab[i];
        }
        return result;
    }

    @Override
    public FlowElement getFlowElementById(String id) {
        for (FlowElement fe : getFlowElement()) {
            if (fe.getId().equals(id)) {
                return fe;
            }
        }
        return null;
    }

    @Override
    public boolean hasFlowElement() {
        return this.getModelObject().isSetFlowElement();
    }

    @Override
    public void unsetFlowElement() {
        this.getModelObject().unsetFlowElement();
    }

    @Override
    public void addFlowElement(FlowElement fe) {
        addToChildren(this.getModelObject().getFlowElement(), fe);
    }

    @Override
    public void removeFlowElement(FlowElement fe) {
        removeFromChildren(this.getModelObject().getFlowElement(), fe);
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T extends FlowElement> List<T> getFlowElementsByClass(Class<T> c) {
        List<T> l = new ArrayList<T>();
        for (FlowElement fe : getFlowElement()) {
            if (c.isAssignableFrom(fe.getClass())) {
                l.add((T) fe);
            }
        }
        return l;
    }

    @Override
    public Artifact[] getArtifact() {
        XmlObject[] t = createChildrenArray(getModelObject().getArtifact(), EJaxbTArtifact.class,
                ANY_QNAME);
        Artifact[] result = new Artifact[t.length];
        for (int i = 0; i < t.length; i++) {
            result[i] = (Artifact) t[i];
        }
        return result;
    }

    @Override
    public void addArtifact(Artifact a) {
        addToChildren(getModelObject().getArtifact(), a);
    }

    @Override
    public void removeArtifact(Artifact a) {
        removeFromChildren(getModelObject().getArtifact(), a);
    }

    @Override
    public boolean hasArtifact() {
        return this.getModelObject().isSetArtifact();
    }

    @Override
    public void unsetArtifact() {
        this.getModelObject().unsetArtifact();
    }
}
