/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.DiagramElement;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TPlane;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbDiagramElement;
import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbPlane;


abstract class AbstractTPlaneImpl<Model extends EJaxbPlane> 
extends AbstractTNodeImpl<Model> implements TPlane {

	protected AbstractTPlaneImpl(XmlContext xmlContext, Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}
	
	@Override
	public DiagramElement[] getDiagramElement() {
		XmlObject[] tab = createChildrenArray(this.getModelObject().getDiagramElement(), EJaxbDiagramElement.class, ANY_QNAME);
		DiagramElement[] result = new DiagramElement[tab.length];
		for(int i=0; i<tab.length; i++){
			result[i] = (DiagramElement) tab[i];
		}
		return result;
	}

	@Override
	public boolean hasDiagramElement() {
		return this.getModelObject().isSetDiagramElement();
	}

	@Override
	public void unsetDiagramElement() {
		this.getModelObject().unsetDiagramElement();
	}
	
	@Override
	public void addDiagramElement(DiagramElement diagramElement) {
		addToChildren(this.getModelObject().getDiagramElement(), diagramElement);
	}

	@Override
	public void removeDiagramElement(DiagramElement diagramElement) {
		removeFromChildren(this.getModelObject().getDiagramElement(), diagramElement);
	}

}
