package com.ebmwebsourcing.easybpmn.bpmn2bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExclusiveGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Gateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

public class GenerationProperties {

    private XmlContext context;
    
	private Collection<com.ebmwebsourcing.easywsdl11.api.element.Definitions> descs = null;
	private com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs = null;
	private Definitions artefactDesc = null;
	private BPELProcess bpelProcess = null;
	private Set<QName> elementsToImport = new HashSet<QName>();

	private List<Gateway> gatewaysAlreadyGenerated = new ArrayList<Gateway>();

	private List<Gateway> alreadyGeneratedLoops = new ArrayList<Gateway>();
    private List<ExclusiveGateway> alreadyGeneratedLoopExit = new ArrayList<ExclusiveGateway>();
	private Map<Gateway,Set<SequenceFlow>> loopers = null;
	private Activity currentWhileParent;


	public boolean isLoopDiverger(Gateway g){
		return loopers.containsKey(g);
	}

	public Set<SequenceFlow> getLoopingFlows(ExclusiveGateway eg){
		return loopers.get(eg);
	}

	public FlowElement getLoopExit(Gateway g){
		Set<SequenceFlow> sfs = loopers.get(g);
		for(FlowElement elt : g.getOutgoingFlowNodes()){
			boolean none = true;	
			for(SequenceFlow sf : sfs){
				if(sf.getTargetRef().getId().equals(elt.getId())){
					none = false;
					break;
				}
			}
			if(none){
				return elt;
			}
		}
		return null;
	}
	
	public <T extends XmlObject> T newInstance(Class<T> clazz){
	    if(context==null){
	        context = new XmlContextFactory().newContext();
	    }
	    return context.getXmlObjectFactory().create(clazz);
	}

	
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	public void setLoopers(Map<Gateway, Set<SequenceFlow>> loopers) {
		this.loopers = loopers;
	}
	public BPELProcess getBpelProcess() {
		return bpelProcess;
	}
	public void setBpelProcess(BPELProcess bpelProcess) {
		this.bpelProcess = bpelProcess;
	}
	public Definitions getArtefactDesc() {
		return artefactDesc;
	}
	public void setArtefactDesc(Definitions artefactDesc) {
		this.artefactDesc = artefactDesc;
	}
	public com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions getBPMNDefinitions() {
		return defs;
	}
	public void setBPMNDefinitions(com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions definitions) {
		this.defs = definitions;
	}
	public Collection<Definitions> getDescs() {
		return descs;
	}
	public void setDescs(Collection<Definitions> descs) {
		this.descs = descs;
	}
	public List<Gateway> getGatewaysAlreadyGenerated() {
		return gatewaysAlreadyGenerated;
	}
	public void setGatewaysAlreadyGenerated(List<Gateway> gatewaysAlreadyGenerated) {
		this.gatewaysAlreadyGenerated = gatewaysAlreadyGenerated;
	}
	public List<Gateway> getAlreadyGeneratedLoops() {
		return alreadyGeneratedLoops;
	}
	public List<ExclusiveGateway> getAlreadyGeneratedLoopExit() {
		return alreadyGeneratedLoopExit;
	}
	public Activity getCurrentWhileParent() {
		return currentWhileParent;
	}
	public void setCurrentWhileParent(Activity currentWhileParent) {
		this.currentWhileParent = currentWhileParent;
	}
    public Set<QName> getElementsToImport() {
        return elementsToImport;
    }
	
}
