
package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Error;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Fault;
import com.ebmwebsourcing.easywsdl11.api.element.Input;
import com.ebmwebsourcing.easywsdl11.api.element.Output;
import com.ebmwebsourcing.easywsdl11.api.element.Part;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Types;

public class AbstractWSDLGenerator {

    public static Definitions generateAbstractWSDL(Interface itfM, GenerationProperties gp)
            throws BPMNException {
        boolean found = false;
        Set<Element> elmtToImports = new HashSet<Element>();

        Definitions res = null;
        
        if(itfM.hasImplementationRef()){
            QName implemRef = itfM.getImplementationRef();
            //res.setTargetNamespace(implemRef.getNamespaceURI());
            for(Import impt : DefinitionsHelper.getParentDefinitions(itfM).getImports()) {
                if(impt.getNamespace().equals(implemRef.getNamespaceURI())
                        && impt.isWSDL11Import()) {
                    Definitions defs = impt.getWSDL11Definitions();
                    PortType pt = defs.getPortTypeByName(implemRef.getLocalPart());
                    if(pt!=null){
                        found = true;
                        
                        res = WSDLGeneratorHelper.getOrCreateDefinitions(implemRef.getNamespaceURI());
                        //res.addPortType(pt);
                        addPortTypeAndRelatedMessages(pt, defs, res);

                        elmtToImports.addAll(findElementToImport(pt,defs));

                        break;
                    }
                }
            }
        }

        if(!found){
            //res.setTargetNamespace(gp.getBPMNDefinitions().getTargetNamespace());
            res = WSDLGeneratorHelper.getOrCreateDefinitions(gp.getBPMNDefinitions().getTargetNamespace()); 
            //res.addPortType(createPortType(itfM, res, elmtToImports, gp));
            addPortType(createPortType(itfM, res, elmtToImports, gp), res);
        }
        
        res.setName(itfM.getName().replace(" ",""));

        // create import schema
        Types types = gp.newInstance(Types.class);
        res.setTypes(types);

        List<String> alreadyImportedSchema = new ArrayList<String>();
        for(Schema s : types.getAnyXmlObjects(Schema.class)) {
            alreadyImportedSchema.add(s.getTargetNamespace());
        }
        for (Element elmt : elmtToImports) {
            Schema model = SchemaHelper.findParentSchema(elmt);
            if (!alreadyImportedSchema.contains(model.getTargetNamespace())) {
                types.addAnyXmlObject(model);

                alreadyImportedSchema.add(model.getTargetNamespace());
            }
        }

        return res;
    }
    

    private static void addPortTypeAndRelatedMessages(PortType pt, Definitions readDefs, Definitions resultDefs) {
        addPortType(pt, resultDefs);
        for(com.ebmwebsourcing.easywsdl11.api.element.Operation op : pt.getOperations()) {
            if(op.hasInput()) {
                addMessage(readDefs.getMessageByName(op.getInput().getMessage().getLocalPart()), resultDefs);
            }
            if(op.hasOutput()) {
                addMessage(readDefs.getMessageByName(op.getOutput().getMessage().getLocalPart()), resultDefs);
            }
            if(op.getFaults()!=null) {
                for(Fault f : op.getFaults()) {
                    addMessage(readDefs.getMessageByName(f.getMessage().getLocalPart()), resultDefs);
                }
            }
        }
    }

    private static void addPortType(PortType pt, Definitions defs) {
        if(defs.getPortTypeByName(pt.getName())==null) {
            defs.addPortType(pt);
        }
    }
    
    private static void addMessage(com.ebmwebsourcing.easywsdl11.api.element.Message m, Definitions defs) {
        if(defs.getMessageByName(m.getName())==null) {
            defs.addMessage(m);
        }
    }
    
    
    private static Set<Element> findElementToImport(PortType pt, Definitions defs) {
        Set<Element> res = new HashSet<Element>();
        for(com.ebmwebsourcing.easywsdl11.api.element.Operation op : pt.getOperations()){
            if(op.hasInput()){
                res.addAll(findMessageElements(op.getInput().getMessage().getLocalPart(), defs));
            }
            if(op.hasOutput()){
                res.addAll(findMessageElements(op.getOutput().getMessage().getLocalPart(), defs));
            }
            for(Fault f : op.getFaults()) {
                res.addAll(findMessageElements(f.getMessage().getLocalPart(), defs));
            }
        }
        return res;
    }
    
    private static Set<Element> findMessageElements(String msgName, Definitions defs) {
        Set<Element> res = new HashSet<Element>();
        com.ebmwebsourcing.easywsdl11.api.element.Message msg = defs.getMessageByName(msgName);
        for(Part part : msg.getParts()){
            res.add(SchemaHelper.findElementByQName(defs, part.getElement()));
        }
        return res;
    }


    private static PortType createPortType(Interface itfM, Definitions res, 
            Set<Element> elmtToImports, GenerationProperties gp) throws BPMNException {
        // create portype
        PortType itfT = gp.newInstance(PortType.class);
        itfT.setName(itfM.getName());
        
        for (Operation opM : itfM.getOperations()) {
            com.ebmwebsourcing.easywsdl11.api.element.Operation op = gp
                    .newInstance(com.ebmwebsourcing.easywsdl11.api.element.Operation.class);
            itfT.addOperation(op);

            if ((gp.getBPMNDefinitions() != null) && (opM.getName() != null)) {
                op.setName(opM.getName());
            }

            // message in
            if (opM.hasInMessageRef()) {
                Input input = gp.newInstance(Input.class);
                com.ebmwebsourcing.easywsdl11.api.element.Message message = createOrFindMessage(opM.getInMessageRef().getLocalPart(), res, gp, elmtToImports);
                input.setName(message.getName());
                input.setMessage(new QName(res.getTargetNamespace(), message.getName()));
                op.setInput(input);
            }

            // message out
            if (opM.hasOutMessageRef()) {
                Output output = gp.newInstance(Output.class);
                com.ebmwebsourcing.easywsdl11.api.element.Message message = createOrFindMessage(opM.getOutMessageRef().getLocalPart(), res, gp, elmtToImports);
                output.setName(message.getName());
                output.setMessage(new QName(res.getTargetNamespace(), message.getName()));
                op.setOutput(output);
            }

            if (opM.hasErrorRef()) {
                for (QName errorRef : opM.getErrorRef()) {
                    Fault fault = gp.newInstance(Fault.class);

                    for (Error error : gp.getBPMNDefinitions().getErrors()) {
                        if (error.getId().equals(errorRef.getLocalPart())) {
                            com.ebmwebsourcing.easywsdl11.api.element.Message message = res
                                    .getMessageByName(error.getName());
                            fault.setName(error.getName());

                            if (message == null) {
                                message = gp
                                        .newInstance(com.ebmwebsourcing.easywsdl11.api.element.Message.class);
                                message.setName(error.getName());

                                for (ItemDefinition item : gp.getBPMNDefinitions()
                                        .getItemDefinitions()) {
                                    if (item.getStructureRef().equals(error.getStructureRef())) {
                                        Part part = gp.newInstance(Part.class);
                                        part.setElement(item.getStructureRef());
                                        message.addPart(part);
                                        elmtToImports.add(gp.getBPMNDefinitions()
                                                .findImportedElement(item.getStructureRef()));
                                        // elmtToImports.add(part.findElement());
                                        break;
                                    }
                                }
                                addMessage(message, res);
                            }

                            fault.setMessage(new QName(res.getTargetNamespace(), message
                                    .getName()));
                            break;
                        }
                    }

                    op.addFault(fault);
                }
            }
        }
        
        return itfT;
    }

    
    private static com.ebmwebsourcing.easywsdl11.api.element.Message createOrFindMessage(
            String msgId, Definitions defs, GenerationProperties gp, Set<Element> elmtToImports) throws BPMNException{
        for (Message msg : gp.getBPMNDefinitions().getMessages()) {
            if (msg.getId().equals(msgId)) {
                com.ebmwebsourcing.easywsdl11.api.element.Message message = defs
                        .getMessageByName(msg.getName());
                if (message == null) {
                    message = buildMessage(msg, gp, elmtToImports);
                    addMessage(message, defs);
                }
                return message;
            }
        }
        return null;
    }
    
    private static com.ebmwebsourcing.easywsdl11.api.element.Message buildMessage(Message msg,
            GenerationProperties gp, Set<Element> elmtToImports) throws BPMNException {
        com.ebmwebsourcing.easywsdl11.api.element.Message message = gp
                .newInstance(com.ebmwebsourcing.easywsdl11.api.element.Message.class);
        message.setName(msg.getName());

        for (ItemDefinition item : gp.getBPMNDefinitions().getItemDefinitions()) {
            if (item.getId().equals(msg.getItemRef().getLocalPart())) {
                Part part = gp.newInstance(Part.class);
                part.setElement(item.getStructureRef());
                message.addPart(part);
                Element elt = gp.getBPMNDefinitions().findImportedElement(item.getStructureRef());
                elmtToImports.add(elt);
                part.setName(elt.getName());
                break;
            }
        }
        return message;
    }

}
