
package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EndPoint;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;

public class ConcreteWSDLGenerator {

    
    public static void generateConcreteWSDL(Interface itf, Participant participant,
            Definitions abstractDesc, GenerationProperties gp) throws BPMNException {
        
        if (itf.hasImplementationRef()) {

            // There always a unique service whit possibly multiple ports
            Service s = null;
            if(abstractDesc.getServices()==null || abstractDesc.getServices().length==0) {
                s = gp.newInstance(Service.class);
                s.setName(abstractDesc.getName() + "Service");
                abstractDesc.addService(s);
            }
            else {
                s = abstractDesc.getServices()[0];
            }

            // search for the BPMN endpoint
            // if it exists find the corresponding port in the imported wsdls
            // check that its binding refers to the correct portype
            // finally add the port and the binding to the service
            if (participant.hasEndPointRef()) {
                for (QName qn : participant.getEndPointRef()) {
                    EndPoint endpoint = DefinitionsHelper.findBPMNObject(gp
                            .getBPMNDefinitions(), qn, EndPoint.class);
                    if (endpoint != null && endpoint.hasEndPointRef()) {
                        Port p = WSDLGeneratorHelper.findPortInImports(endpoint.getEndPointRef(),
                                gp.getBPMNDefinitions());
                        Binding binding = WsdlHelper.findParentDefinitions(p).getBindingByName(
                                p.getBinding().getLocalPart());
                        if (binding.getType().equals(itf.getImplementationRef())) {
                            if(abstractDesc.getBindingByName(binding.getName())==null) {
                                abstractDesc.addBinding(binding);
                            }
                            if(s.getPortByName(p.getName())==null) {
                                s.addPort(p);
                            }
                        }
                    }
                }
                if (s.getPorts() != null && s.getPorts().length > 0) {
                    return;
                }
            }

            // if no bpmn endpoint exists, search for wsdl endpoints having a
            // binding for this the port type
            QName implemRef = itf.getImplementationRef();
            Definitions defs = WSDLGeneratorHelper.findDefinitionsContainingInterfaceInImports(implemRef, gp.getBPMNDefinitions());
            if(defs!=null) {
                List<String> bindings = new ArrayList<String>();
                for (Binding binding : defs.getBindings()) {
                    if (binding.hasType() && binding.getType().equals(implemRef)) {
                        bindings.add(binding.getName());
                    }
                }

                for (Service service : defs.getServices()) {
                    for (Port port : service.getPorts()) {
                        if (bindings.contains(port.getBinding().getLocalPart())) {
                            if(s.getPortByName(port.getName())==null) {
                                s.addPort(port);
                            }
                            Binding binding = defs.getBindingByName(port.getBinding().getLocalPart()); 
                            if(abstractDesc.getBindingByName(binding.getName())==null) {
                                abstractDesc.addBinding(binding);
                            }
                        }
                    }
                }
            }

            // if no endpoint can be found for the portype do not build a
            // concrete wsdl
        }
        
    }
    
    
}
