/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import java.util.HashSet;
import java.util.Set;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;


public class WSDLGenerator  {

    
	public Set<com.ebmwebsourcing.easywsdl11.api.element.Definitions> generate(Definitions def) throws BPMNException {
		return generate(def, new GenerationProperties());
	}

	
	public Set<com.ebmwebsourcing.easywsdl11.api.element.Definitions> generate(Definitions def, GenerationProperties gp) throws BPMNException {
	    gp.setBPMNDefinitions(def);
	    WSDLGeneratorHelper.init();

	    Set<com.ebmwebsourcing.easywsdl11.api.element.Definitions> res = new HashSet<com.ebmwebsourcing.easywsdl11.api.element.Definitions>();
		for(Collaboration c: def.getCollaborations()) {
			for(Participant participant: c.getParticipant()) {
			    if(participant.hasInterfaceRef() && participant.getInterfaceRef().length>0) {
			        this.generate(participant, gp);
			    }
			}
			
			res.addAll(WSDLGeneratorHelper.getAllDefinitions());

			com.ebmwebsourcing.easywsdl11.api.element.Definitions artefactDesc = ArtefactWSDLGenerator.generateArtefactWSDL(c, res, gp);
			res.add(artefactDesc);
			gp.setArtefactDesc(artefactDesc);
		}

		return res;
	}


	public void generate(Participant participant, GenerationProperties gp) throws BPMNException {
		for(QName itfQname : participant.getInterfaceRef()){
		    Interface itf = DefinitionsHelper.findBPMNObject(gp.getBPMNDefinitions(), itfQname, Interface.class);
		    
		    com.ebmwebsourcing.easywsdl11.api.element.Definitions abstractDesc = AbstractWSDLGenerator.generateAbstractWSDL(itf, gp);
		    ConcreteWSDLGenerator.generateConcreteWSDL(itf, participant, abstractDesc, gp);

		}
	}

}
