/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.test.unit.activity.task;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.ObjectFactory;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TEmpty;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.SequenceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ValidatorManagerImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.inout.BPELWriterImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ReceiveTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RootElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SendTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ServiceTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Task;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGenerator;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.ArtefactWSDLGenerator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BPELTaskGeneratorTest {
    private static DocumentBuilderFactory domFactory;
    private static ObjectFactory bpelFactory;
    private static XmlContext context;
    static Sequence seq;
    static GenerationProperties gp;
    static Participant participant;
    static PartnerRole role;
    static Operation operation;
    static Interface itf;
    static BPELVariable<?> var;

    @BeforeClass
    public static void init() throws Exception {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        ValidatorManagerImpl.getInstance();
        domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        bpelFactory = new ObjectFactory();
        context = new XmlContextFactory().newContext();
        seq = new SequenceImpl(new TSequence(), null);
        gp = new GenerationProperties();
        Definitions definitions = (Definitions)context.getXmlObjectFactory().create(Definitions.class);
        definitions.setId("defsID");
        definitions.setTargetNamespace("http://TNS");
        gp.setBPMNDefinitions(definitions);
        participant = (Participant)context.getXmlObjectFactory().create(Participant.class);
        participant.setName("MyPartner");
        participant.setId("MyPartnerId");
        role = (PartnerRole)context.getXmlObjectFactory().create(PartnerRole.class);
        role.setId("MyRoleId");
        role.setName("MyRoleName");
        role.addParticipantRef(new QName(participant.getId()));
        definitions.addRootElement((RootElement)role);
        Collaboration c = (Collaboration)context.getXmlObjectFactory().create(Collaboration.class);
        c.setName("collName");
        c.setId("collId");
        c.addParticipant(participant);
        definitions.addRootElement((RootElement)c);
        itf = (Interface)context.getXmlObjectFactory().create(Interface.class);
        itf.setName("MyItf");
        itf.setId("MyItf");
        definitions.addRootElement((RootElement)itf);
        operation = (Operation)context.getXmlObjectFactory().create(Operation.class);
        operation.setName("MyOperation");
        operation.setId("MyOperation");
        itf.addOperation(operation);
        ItemDefinition itemDef = (ItemDefinition)context.getXmlObjectFactory().create(ItemDefinition.class);
        itemDef.setId("itemDefId");
        itemDef.setStructureRef(new QName("structureRef"));
        definitions.addRootElement((RootElement)itemDef);
        Message msgIn = (Message)context.getXmlObjectFactory().create(Message.class);
        msgIn.setId("msgInId");
        msgIn.setItemRef(new QName(itemDef.getId()));
        operation.setInMessageRef(new QName(msgIn.getId()));
        definitions.addRootElement((RootElement)msgIn);
        Message msgOut = (Message)context.getXmlObjectFactory().create(Message.class);
        msgOut.setId("msgOutId");
        msgOut.setItemRef(new QName(itemDef.getId()));
        operation.setOutMessageRef(new QName(msgOut.getId()));
        definitions.addRootElement((RootElement)msgOut);
        participant.addInterfaceRef(new QName(itf.getId()));
        BPELProcessImpl bp = new BPELProcessImpl(URI.create("bpel"), new TProcess(), null, null);
        var = bp.createBPELElementVariable("structureRefVariable", itemDef.getStructureRef(), BPELElementVariable.VariableType.ELEMENT);
        gp.setBpelProcess((BPELProcess)bp);
        gp.setArtefactDesc(ArtefactWSDLGenerator.generateArtefactWSDL((Collaboration)c, new ArrayList(), (GenerationProperties)gp));
    }

    private void printBpelElement(Object bpelElement) throws ParserConfigurationException, JAXBException, BPELException {
        Document doc = domFactory.newDocumentBuilder().newDocument();
        ((BPELWriterImpl)BPELFactoryImpl.getInstance().newBPELWriter()).getJaxbContext().createMarshaller().marshal(bpelElement, (Node)doc);
        System.out.println(XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    @Test
    public void testServiceTask() throws URISyntaxException, BPMNException, SchemaException, BPELException, ParserConfigurationException, JAXBException {
        ServiceTask serviceTask = (ServiceTask)context.getXmlObjectFactory().create(ServiceTask.class);
        serviceTask.setName("MyService");
        serviceTask.setOperationRef(new QName(operation.getId()));
        BPELGenerator gen = new BPELGenerator();
        gen.generatePartnerLinks(participant, gp);
        Invoke invoke = gen.generateInvoke(serviceTask, (Activity)seq, gp);
        Assert.assertEquals((Object)serviceTask.getName(), (Object)invoke.getName());
        Assert.assertEquals((Object)operation.getName(), (Object)invoke.getOperation());
        Assert.assertEquals((Object)participant.getInterfaceRef()[0].getLocalPart(), (Object)invoke.getInterface().getLocalPart());
        Assert.assertEquals((Object)var.getQName().getLocalPart(), (Object)invoke.getInputVariable());
        Assert.assertEquals((Object)var.getQName().getLocalPart(), (Object)invoke.getOutputVariable());
        this.printBpelElement(bpelFactory.createInvoke((TInvoke)((AbstractSchemaElementImpl)invoke).getModel()));
    }

    @Test
    public void testReceiveTask() throws URISyntaxException, BPMNException, SchemaException, BPELException, ParserConfigurationException, JAXBException {
        ReceiveTask receiveTask = (ReceiveTask)context.getXmlObjectFactory().create(ReceiveTask.class);
        receiveTask.setName("Mytask");
        receiveTask.setInstantiate(true);
        receiveTask.setOperationRef(new QName(operation.getId()));
        BPELGenerator gen = new BPELGenerator();
        gen.generatePartnerLinks(participant, gp);
        Receive receive = gen.generateReceive(receiveTask, (Activity)seq, gp);
        Assert.assertEquals((Object)receiveTask.getName(), (Object)receive.getName());
        Assert.assertEquals((Object)receiveTask.isInstantiate(), (Object)receive.getCreateInstance());
        Assert.assertEquals((Object)operation.getName(), (Object)receive.getOperation());
        Assert.assertEquals((Object)itf.getName(), (Object)receive.getInterface().getLocalPart());
        Assert.assertEquals((Object)var.getQName().getLocalPart(), (Object)receive.getInputVariable());
        this.printBpelElement(bpelFactory.createReceive((TReceive)((AbstractSchemaElementImpl)receive).getModel()));
    }

    @Test
    public void testSendTask() throws URISyntaxException, BPMNException, SchemaException, BPELException, ParserConfigurationException, JAXBException {
        SendTask sendTask = (SendTask)context.getXmlObjectFactory().create(SendTask.class);
        sendTask.setName("MyTask");
        sendTask.setOperationRef(new QName(operation.getId()));
        participant.setName("MyPartner");
        BPELGenerator gen = new BPELGenerator();
        gen.generatePartnerLinks(participant, gp);
        Invoke sendInvoke = gen.generateInvoke(sendTask, (Activity)seq, gp);
        Assert.assertEquals((Object)sendTask.getName(), (Object)sendInvoke.getName());
        Assert.assertEquals((Object)itf.getName(), (Object)sendInvoke.getInterface().getLocalPart());
        Assert.assertEquals((Object)operation.getName(), (Object)sendInvoke.getOperation());
        Assert.assertEquals((Object)var.getQName().getLocalPart(), (Object)sendInvoke.getInputVariable());
        Assert.assertNull((Object)sendInvoke.getOutputVariable());
        this.printBpelElement(bpelFactory.createInvoke((TInvoke)((AbstractSchemaElementImpl)sendInvoke).getModel()));
    }

    @Test
    public void testAbstractTask() throws URISyntaxException, BPMNException, SchemaException, BPELException, ParserConfigurationException, JAXBException {
        Task abstractTask = (Task)context.getXmlObjectFactory().create(Task.class);
        abstractTask.setName("MyTask");
        Empty empty = new BPELGenerator().generateEmpty(abstractTask, (Activity)seq, gp);
        this.printBpelElement(bpelFactory.createEmpty((TEmpty)((AbstractSchemaElementImpl)empty).getModel()));
        Assert.assertEquals((Object)abstractTask.getName(), (Object)empty.getName());
    }
}

