/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.test.unit.process.event;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.ObjectFactory;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.SequenceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ValidatorManagerImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.inout.BPELWriterImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Lane;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.LaneSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ReceiveTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RootElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.StartEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithFlowElements;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGenerator;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGeneratorHelper;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.ArtefactWSDLGenerator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BPELEventGeneratorTest {
    private ObjectFactory bpelFactory;
    private DocumentBuilderFactory domFactory;
    private XmlContext context;

    @Before
    public void init() throws Exception {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        ValidatorManagerImpl.getInstance();
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setNamespaceAware(true);
        this.bpelFactory = new ObjectFactory();
        this.context = new XmlContextFactory().newContext();
    }

    private void printBpelElement(Object bpelElement) throws ParserConfigurationException, JAXBException, BPELException {
        Document doc = this.domFactory.newDocumentBuilder().newDocument();
        ((BPELWriterImpl)BPELFactoryImpl.getInstance().newBPELWriter()).getJaxbContext().createMarshaller().marshal(bpelElement, (Node)doc);
        System.out.println(XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    @Test
    public void testMessageStartEvent() throws BPMNException, BPELException, ParserConfigurationException, JAXBException {
        Definitions definitions = (Definitions)this.context.getXmlObjectFactory().create(Definitions.class);
        definitions.setTargetNamespace("http://TNS");
        Collaboration c = (Collaboration)this.context.getXmlObjectFactory().create(Collaboration.class);
        definitions.addRootElement((RootElement)c);
        c.setId("collId");
        c.setName("collName");
        Process process = (Process)this.context.getXmlObjectFactory().create(Process.class);
        process.setName("MyProcess");
        process.setId("MyProcess");
        definitions.addRootElement((RootElement)process);
        Participant participant = (Participant)this.context.getXmlObjectFactory().create(Participant.class);
        participant.setId("MyPartner");
        participant.setName("MyPartner");
        participant.setProcessRef(new QName(process.getId()));
        c.addParticipant(participant);
        PartnerRole role = (PartnerRole)this.context.getXmlObjectFactory().create(PartnerRole.class);
        role.setId("MyRoleId");
        role.setName("MyRoleName");
        role.addParticipantRef(new QName(participant.getId()));
        definitions.addRootElement((RootElement)role);
        LaneSet laneSet = (LaneSet)this.context.getXmlObjectFactory().create(LaneSet.class);
        process.addLaneSet(laneSet);
        Lane lane = (Lane)this.context.getXmlObjectFactory().create(Lane.class);
        laneSet.addLane(lane);
        StartEvent startEvent = (StartEvent)this.context.getXmlObjectFactory().create(StartEvent.class);
        startEvent.setName("MyStartEvent");
        lane.addFlowNodeRef((FlowNode)startEvent);
        process.addFlowElement((FlowElement)startEvent);
        ReceiveTask receiveTask = (ReceiveTask)this.context.getXmlObjectFactory().create(ReceiveTask.class);
        receiveTask.setName("Mytask");
        receiveTask.setInstantiate(true);
        lane.addFlowNodeRef((FlowNode)receiveTask);
        process.addFlowElement((FlowElement)receiveTask);
        SequenceFlow sequenceFlow = (SequenceFlow)this.context.getXmlObjectFactory().create(SequenceFlow.class);
        sequenceFlow.setName("MySequenceFlow");
        sequenceFlow.setSourceRef((FlowNode)startEvent);
        sequenceFlow.setTargetRef((FlowNode)receiveTask);
        process.addFlowElement((FlowElement)sequenceFlow);
        ItemDefinition itemDef = (ItemDefinition)this.context.getXmlObjectFactory().create(ItemDefinition.class);
        itemDef.setId("itemDefId");
        itemDef.setStructureRef(new QName("tns", "lp"));
        definitions.addRootElement((RootElement)itemDef);
        Message message = (Message)this.context.getXmlObjectFactory().create(Message.class);
        message.setName("MyMessage");
        message.setId("MyMessage");
        message.setItemRef(new QName("itemDefId"));
        definitions.addRootElement((RootElement)message);
        Interface itf = (Interface)this.context.getXmlObjectFactory().create(Interface.class);
        itf.setName("MyItfName");
        itf.setId("MyItf");
        participant.addInterfaceRef(new QName(itf.getId()));
        definitions.addRootElement((RootElement)itf);
        Operation operation = (Operation)this.context.getXmlObjectFactory().create(Operation.class);
        operation.setName("MyOperationName");
        operation.setId("MyOperation");
        operation.setInMessageRef(new QName(message.getId()));
        itf.addOperation(operation);
        receiveTask.setMessageRef(new QName(message.getId()));
        receiveTask.setOperationRef(new QName(operation.getId()));
        GenerationProperties gp = new GenerationProperties();
        gp.setBPMNDefinitions(definitions);
        BPELProcessImpl bp = new BPELProcessImpl(URI.create("bpel"), new TProcess(), null, null);
        bp.createBPELElementVariable("structureRefVariable", itemDef.getStructureRef(), BPELElementVariable.VariableType.ELEMENT);
        gp.setBpelProcess((BPELProcess)bp);
        Set s = BPELGeneratorHelper.getAllStartingNodes((Process)process);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((long)1L, (long)s.size());
        Assert.assertEquals((Object)startEvent, s.iterator().next());
        List l = new BPELGenerator().detectAllStartingNodes((WithFlowElements)process);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((Object)receiveTask, l.get(0));
        gp.setArtefactDesc(ArtefactWSDLGenerator.generateArtefactWSDL((Collaboration)c, new ArrayList(), (GenerationProperties)gp));
        BPELGenerator gen = new BPELGenerator();
        gen.generatePartnerLinks(participant, gp);
        Receive receive = gen.generateReceive(receiveTask, (Activity)new SequenceImpl(new TSequence(), null), gp);
        Assert.assertNotNull((Object)receive);
        Assert.assertEquals((Object)itf.getName(), (Object)receive.getInterface().getLocalPart());
        Assert.assertEquals((Object)operation.getName(), (Object)receive.getOperation());
        Assert.assertEquals((Object)receiveTask.getName(), (Object)receive.getName());
        Assert.assertEquals((Object)"structureRefVariable", (Object)receive.getInputVariable());
        this.printBpelElement(this.bpelFactory.createReceive((TReceive)((AbstractSchemaElementImpl)receive).getModel()));
    }
}

