/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.with.WithName;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.FromAndTo;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Literal;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnAlarm;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBooleanExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDeadlineExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDurationExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TEmpty;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExit;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFlow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TIf;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TLiteral;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnAlarmPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReply;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TTo;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWait;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWhile;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.AssignImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.EmptyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ExitImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.FlowImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.IfImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.InvokeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.PickImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ReceiveImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ReplyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.SequenceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.WaitImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.WhileImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.CopyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.LiteralImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.ToImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4pick.OnAlarmImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4pick.OnMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports.ImportImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELBooleanExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELDeadLineExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELDurationExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELBooleanExpressionImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELDeadLineExpressionImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELDurationExpressionImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Activity;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Assignment;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BaseElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BoundaryEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CallActivity;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.CatchEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInputAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataOutputAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EndEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Event;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventBasedGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExclusiveGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Gateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.IntermediateCatchEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.IntermediateThrowEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ParallelGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ReceiveTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SendTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ServiceTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.StartEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Task;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.TerminateEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ThrowEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.TimerEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TBaseElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TFlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.ItemAwareElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithDefaultSequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithFlowElements;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGeneratorHelper;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELProcessWriterHelper;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.extension.ExtensionAdapter;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.WSDLGenerator;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.WSDLGeneratorHelper;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.DOMOutputter;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;

public class BPELGenerator {
    public List<BPELProcess> generate(Definitions def) throws BPMNException {
        System.out.println("***** definitions are: " + def.getId());
        return this.generate(def, null);
    }

    public List<BPELProcess> generate(Definitions def, String writingPath) throws BPMNException {
        ArrayList<BPELProcess> res = new ArrayList<BPELProcess>();
        GenerationProperties gp = new GenerationProperties(def);
        BPELGeneratorHelper.addDefaultExternalParticipant(def);
        WSDLGenerator wsdlGen = new WSDLGenerator();
        Set<com.ebmwebsourcing.easywsdl11.api.element.Definitions> descs = wsdlGen.generate(def, gp);
        HashMap schemaImports = new HashMap();
        for (Collaboration c : def.getCollaborations()) {
            for (Participant participant : c.getParticipant()) {
                Process p;
                if (!participant.hasProcessRef() || (p = (Process)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)participant.getProcessRef(), Process.class)).getFlowNode() == null || p.getFlowNode().length == 0) continue;
                BPELProcess bpel = this.generate(participant, gp);
                res.add(bpel);
                for (com.ebmwebsourcing.easywsdl11.api.element.Definitions defs : descs) {
                    this.addDescriptionImport(bpel, defs);
                }
                schemaImports.put(bpel.getQName(), new HashMap());
                block5: for (QName elt : gp.getElementsToImport()) {
                    List elts = bpel.getImports().findElementsInAllSchema(elt);
                    if (elts != null && !elts.isEmpty()) continue;
                    for (Import impt : def.getImports()) {
                        com.ebmwebsourcing.easywsdl11.api.element.Definitions wsdlDefs;
                        Schema s;
                        if (impt.isXSDImport() && impt.getNamespace().equals(elt.getNamespaceURI()) && SchemaHelper.findElementByQName((XmlObject)(s = impt.getSchema()), (QName)elt) != null) {
                            ((Map)schemaImports.get(bpel.getQName())).put(impt.getLocation(), s);
                            this.addSchemaImport(bpel, s, impt.getLocation());
                            continue block5;
                        }
                        if (!impt.isWSDL11Import() || !impt.getNamespace().equals(elt.getNamespaceURI()) || SchemaHelper.findElementByQName((XmlObject)(wsdlDefs = impt.getWSDL11Definitions()), (QName)elt) == null) continue;
                        ((Map)schemaImports.get(bpel.getQName())).put(impt.getLocation(), wsdlDefs);
                        this.addDescriptionImport(bpel, wsdlDefs);
                        continue block5;
                    }
                }
            }
        }
        if (writingPath != null) {
            try {
                for (com.ebmwebsourcing.easywsdl11.api.element.Definitions defs : descs) {
                    if (defs.hasTypes()) {
                        for (Schema schema : (Schema[])defs.getTypes().getAnyXmlObjects(Schema.class)) {
                            Map<String, Schema> impts = WSDLGeneratorHelper.findImportedSchemas(schema);
                            for (Map.Entry<String, Schema> impt : impts.entrySet()) {
                                BPELProcessWriterHelper.writeFile(writingPath, impt.getKey(), (XmlObject)impt.getValue());
                            }
                        }
                    }
                    BPELProcessWriterHelper.writeFile(writingPath, defs.getName() + ".wsdl", (XmlObject)defs);
                }
                for (BPELProcess bpel : res) {
                    org.w3c.dom.Document doc = BPELFactoryImpl.getInstance().newBPELWriter().getDocument(bpel);
                    BPELProcessWriterHelper.writeFile(writingPath, bpel.getName() + ".bpel", XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)doc));
                    for (String location : ((Map)schemaImports.get(bpel.getQName())).keySet()) {
                        BPELProcessWriterHelper.writeFile(writingPath, BPELGeneratorHelper.getFileNameFromImportLocation(location), (XmlObject)((Map)schemaImports.get(bpel.getQName())).get(location));
                    }
                }
            }
            catch (Exception e) {
                throw new BPMNException("A problem occured during the process writing.", (Throwable)e);
            }
        }
        return res;
    }

    private BPELProcess generate(Participant participant, GenerationProperties gp) throws BPMNException {
        Process p = (Process)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)participant.getProcessRef(), Process.class);
        String processName = BPELGeneratorHelper.getBPELProcessName(p);
        BPELProcessImpl res = new BPELProcessImpl(URI.create(processName), new TProcess(), null, null);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)p, (BPELElement)res);
        res.setName(processName);
        res.setTargetNamespace(gp.getBPMNDefinitions().getTargetNamespace());
        gp.setBpelProcess((BPELProcess)res);
        gp.setCurrentParticipant(participant);
        this.generatePartnerLinks(participant, gp);
        this.generateProcess((BPELProcess)res, p, gp);
        return res;
    }

    public void generatePartnerLinks(Participant participant, GenerationProperties gp) throws BPMNException {
        for (PartnerLinkType plt : gp.getPartnerLinkTypes().keySet()) {
            if (plt.getRoles() == null || plt.getRoles().length <= 0) continue;
            PartnerLink pl = gp.getBpelProcess().createPartnerLink();
            pl.setName(plt.getName().replace("PLT", ""));
            String role = plt.getRoles()[0].getName();
            Participant pltParticipant = gp.getPartnerLinkTypes().get(plt);
            if (pltParticipant == participant) {
                pl.setMyRole(role);
            } else {
                pl.setPartnerRole(role);
            }
            pl.setPartnerLinkType(new QName(BPELGeneratorHelper.getPartnerLinkTypeNS(plt), plt.getName()));
        }
    }

    private void generateProcess(BPELProcess bpel, Process bpmn, GenerationProperties gp) throws BPMNException {
        try {
            SequenceImpl seqMain = new SequenceImpl(new TSequence(), (BPELElement)bpel);
            seqMain.setName("main");
            bpel.setActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seqMain);
            List<FlowNode> starts = this.detectAllStartingNodes((WithFlowElements)bpmn, gp);
            gp.setLoopers(BPELGeneratorHelper.findLoopDivergers((WithFlowElements)bpmn, starts));
            if (starts.size() == 1) {
                this.generateActivity((FlowElement)starts.get(0), (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seqMain, gp);
            } else if (starts.size() > 1) {
                this.generateStartingPick(starts, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seqMain, true, gp);
            }
        }
        catch (BPELException e) {
            throw new BPMNException("An error occured during BPEL process generation.", (Throwable)e);
        }
    }

    public List<FlowNode> detectAllStartingNodes(WithFlowElements bpmn, GenerationProperties gp) throws BPMNException {
        ArrayList<FlowNode> l = new ArrayList<FlowNode>();
        for (FlowNode fn : bpmn.getFlowElementsByClass(FlowNode.class)) {
            if (fn instanceof StartEvent) {
                if (BPELGeneratorHelper.getEventDefinition((WithEventDefinition)((StartEvent)fn), gp.getBPMNDefinitions()) == null) {
                    l.addAll(fn.getOutgoingFlowNodes());
                    continue;
                }
                l.add(fn);
                continue;
            }
            if (!fn.getIncomingFlowNodes().isEmpty()) continue;
            l.add(fn);
        }
        return l;
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateNextActivity(FlowElement a, BPELElement parent, GenerationProperties gp) throws BPELException, BPMNException {
        System.out.println("************* FlowElement: " + a.getName() + " --- instance of class: " + a.getClass());
        Flow ua = null;
        if (a instanceof Activity) {
            Activity t = (Activity)a;
            System.out.println("************* Taskes: " + t.getName());
            if (t.getOutgoingFlowNodes().size() > 1) {
                Flow f;
                ua = f = this.generateFlow((FlowNode)t, parent, gp);
            } else if (t.getOutgoingFlowNodes().size() == 1) {
                Sequence seq = this.generateSequence((FlowNode)t, parent, gp);
                ua = seq;
            }
        } else if (a instanceof Gateway) {
            Gateway g = (Gateway)a;
            System.out.println("************* gateways: " + g.getName());
            if (g.getOutgoingFlowNodes().size() > 1) {
                com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity f = this.generateActivityFromGateway(g, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)parent, gp);
                ua = f;
            } else if (g.getOutgoingFlowNodes().size() == 1) {
                SequenceImpl seq = new SequenceImpl(new TSequence(), parent);
                this.addActivityInParent((BPELElement)seq, parent);
                ua = this.generateActivity((FlowElement)g.getOutgoingFlowNodes().get(0), (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq, gp);
            }
        } else if (a instanceof Event) {
            Event e = (Event)a;
            System.out.println("************* events: " + e.getName());
            if (e.getOutgoingFlowNodes().size() != 0) {
                if (e.getOutgoingFlowNodes().size() > 1) {
                    Flow f;
                    ua = f = this.generateFlow((FlowNode)e, parent, gp);
                } else if (e.getOutgoingFlowNodes().size() == 1) {
                    ua = this.generateActivity((FlowElement)e.getOutgoingFlowNodes().get(0), (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)parent, gp);
                }
            }
        } else {
            throw new BPMNException("This type of flow element is not supported yet. " + a.getClass());
        }
        return ua;
    }

    private Sequence generateSequence(FlowNode a, BPELElement parent, GenerationProperties gp) throws BPELException, BPMNException {
        Sequence seq = null;
        System.out.println("******* Flow node is: " + a.getName());
        if (parent instanceof Sequence) {
            seq = (Sequence)parent;
        } else {
            seq = new SequenceImpl(new TSequence(), parent);
            this.addActivityInParent((BPELElement)seq, parent);
        }
        this.generateActivity((FlowElement)a.getOutgoingFlowNodes().get(0), (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq, gp);
        return seq;
    }

    private Flow generateFlow(FlowNode fn, BPELElement parent, GenerationProperties gp) throws BPELException, BPMNException {
        FlowImpl flow = new FlowImpl(new TFlow(), parent);
        this.addActivityInParent((BPELElement)flow, (BPELElement)((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)parent));
        Process proc = DefinitionsHelper.getParentProcess((FlowElement)fn);
        ArrayList<FlowNode> ifNodes = new ArrayList<FlowNode>();
        for (FlowNode elmt : fn.getOutgoingFlowNodes()) {
            SequenceFlow sf = DefinitionsHelper.getSequenceFlow((WithFlowElements)proc, (String)fn.getId(), (String)elmt.getId());
            if (sf.hasConditionExpression() || fn instanceof WithDefaultSequenceFlow && ((WithDefaultSequenceFlow)fn).getDefault().equals(sf)) {
                ifNodes.add(elmt);
                continue;
            }
            this.generateActivity((FlowElement)elmt, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)flow, gp);
        }
        if (!ifNodes.isEmpty()) {
            this.generateIf(ifNodes, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)flow, (FlowElement)fn, fn instanceof WithDefaultSequenceFlow ? ((WithDefaultSequenceFlow)fn).getDefault() : null, gp);
        }
        return flow;
    }

    public com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateActivity(FlowElement flowElement, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        if (flowElement instanceof Task) {
            return this.generateActivityFromTask((Task)flowElement, seqOrFlowOrScope, gp);
        }
        if (flowElement instanceof CallActivity) {
            return this.generateScope((CallActivity)flowElement, seqOrFlowOrScope, gp);
        }
        if (flowElement instanceof Gateway) {
            return this.generateActivityFromGateway((Gateway)flowElement, seqOrFlowOrScope, gp);
        }
        if (flowElement instanceof Event) {
            return this.generateActivityFromEvent((Event)flowElement, seqOrFlowOrScope, gp);
        }
        throw new BPMNException("Sorry but this element: " + flowElement.getClass() + " cannot be generated into a bpel activity");
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateActivityFromEvent(Event a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        Receive res = null;
        if (a instanceof BoundaryEvent) {
            throw new BPMNException("Sorry, but Boundary events are not supported yet.");
        }
        if (a instanceof CatchEvent) {
            EventDefinition ed = BPELGeneratorHelper.getEventDefinition((WithEventDefinition)((CatchEvent)a), gp.getBPMNDefinitions());
            if (ed instanceof MessageEventDefinition) {
                res = this.generateReceiveIntEvent((CatchEvent)a, (MessageEventDefinition)ed, seqOrFlowOrScope, gp);
            } else if (ed instanceof TimerEventDefinition) {
                res = this.generateWait((WithName)a, (TimerEventDefinition)ed, seqOrFlowOrScope, gp);
            } else if (ed != null) {
                throw new BPMNException("Sorry, but this kind of event is not supported yet : " + ed.getXmlObjectQName());
            }
            this.generateAssign(a.getName(), (DataAssociation[])((CatchEvent)a).getDataOutputAssociation(), seqOrFlowOrScope, gp);
        } else if (a instanceof ThrowEvent) {
            this.generateAssign(a.getName(), (DataAssociation[])((ThrowEvent)a).getDataInputAssociation(), seqOrFlowOrScope, gp);
            EventDefinition ed = BPELGeneratorHelper.getEventDefinition((WithEventDefinition)((ThrowEvent)a), gp.getBPMNDefinitions());
            if (ed instanceof MessageEventDefinition) {
                res = this.generateSendIntEvent((ThrowEvent)a, (MessageEventDefinition)ed, seqOrFlowOrScope, gp);
            } else if (ed instanceof TerminateEventDefinition) {
                ExitImpl exit = new ExitImpl(new TExit(), (BPELElement)seqOrFlowOrScope);
                ExtensionAdapter.getInstance().adaptExtensions((BaseElement)a, (BPELElement)exit);
                this.addActivityInParent((BPELElement)exit, (BPELElement)seqOrFlowOrScope);
            } else if (ed != null) {
                throw new BPMNException("Sorry, but this kind of event is not supported yet : " + ed.getXmlObjectQName());
            }
        }
        this.generateNextActivity((FlowElement)a, (BPELElement)seqOrFlowOrScope, gp);
        return res;
    }

    private Wait generateWait(WithName wn, TimerEventDefinition ed, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        WaitImpl wait = new WaitImpl(new TWait(), (BPELElement)seqOrFlowOrScope);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)wn, (BPELElement)wait);
        this.addActivityInParent((BPELElement)wait, (BPELElement)seqOrFlowOrScope);
        wait.setName(wn.getName());
        if (ed.hasTimeDate()) {
            BPELDeadLineExpressionImpl exp = new BPELDeadLineExpressionImpl(new TDeadlineExpr(), (BPELElement)wait);
            exp.setContent((Object)ed.getTimeDate().getTextContent());
            wait.setUntil((BPELDeadLineExpression)exp);
        } else if (ed.hasTimeDuration()) {
            BPELDurationExpressionImpl exp = new BPELDurationExpressionImpl(new TDurationExpr(), (BPELElement)wait);
            exp.setContent((Object)ed.getTimeDuration().getTextContent());
            wait.setFor((BPELDurationExpression)exp);
        } else {
            if (ed.hasTimeCycle()) {
                throw new BPMNException("No BPEL Activity corresponds to a BPMN Timer Event with a cycle Timer Event Definition.");
            }
            throw new BPMNException("A timer definition must have its Duration, its Date or its Cycle set.");
        }
        return wait;
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateSendIntEvent(ThrowEvent e, MessageEventDefinition ed, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        if (e instanceof EndEvent || BPELGeneratorHelper.isReply(ed, gp.getCurrentParticipant(), gp.getBPMNDefinitions())) {
            Reply reply = this.generateReply(e.getName(), ed.getOperationRef(), (ItemAwareElement[])e.getDataInput(), seqOrFlowOrScope, gp);
            ExtensionAdapter.getInstance().adaptExtensions((BaseElement)e, (BPELElement)reply);
            return reply;
        }
        if (e instanceof IntermediateThrowEvent) {
            return this.generateInOnlyInvoke(e.getName(), ed.getOperationRef(), (ItemAwareElement[])e.getDataInput(), seqOrFlowOrScope, gp);
        }
        throw new BPMNException("Unknown type of event : " + e.getClass());
    }

    private Receive generateReceiveIntEvent(CatchEvent a, MessageEventDefinition ed, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        assert (a != null);
        boolean instantiate = a instanceof StartEvent;
        Receive receive = this.generateReceive(a.getName(), instantiate, ed.getOperationRef(), (ItemAwareElement[])a.getDataOutput(), seqOrFlowOrScope, gp);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)a, (BPELElement)receive);
        return receive;
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateActivityFromGateway(Gateway gateway, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        Object res = null;
        if (gateway instanceof ExclusiveGateway) {
            ExclusiveGateway eg = (ExclusiveGateway)gateway;
            if (gp.getAlreadyGeneratedLoops().contains(gateway)) {
                if (gp.getAlreadyGeneratedLoopExit().contains(gateway)) {
                    return null;
                }
                gp.getAlreadyGeneratedLoopExit().add(eg);
                return this.generateActivity(gp.getLoopExit((Gateway)eg), gp.getCurrentWhileParent(), gp);
            }
            if (gp.isLoopDiverger((Gateway)eg)) {
                gp.getAlreadyGeneratedLoops().add((Gateway)eg);
                this.generateWhile(eg, gp.getLoopingFlows(eg), seqOrFlowOrScope, gp);
            } else {
                List outgoing = eg.getOutgoingFlowNodes();
                res = outgoing.size() == 1 ? this.generateActivity((FlowElement)outgoing.get(0), seqOrFlowOrScope, gp) : this.generateIf(eg, seqOrFlowOrScope, gp);
            }
        } else if (gateway instanceof ParallelGateway) {
            res = this.generateFlow((ParallelGateway)gateway, seqOrFlowOrScope, gp);
        } else if (gateway instanceof EventBasedGateway) {
            if (gp.getAlreadyGeneratedLoops().contains(gateway)) {
                return null;
            }
            if (gp.isLoopDiverger(gateway)) {
                gp.getAlreadyGeneratedLoops().add(gateway);
                return this.generateWhile((EventBasedGateway)gateway, seqOrFlowOrScope, gp);
            }
            res = this.generatePick((EventBasedGateway)gateway, seqOrFlowOrScope, gp);
        } else {
            throw new BPMNException("Sorry but this element: " + gateway.getClass() + " cannot be generated into a bpel activity");
        }
        return res;
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateStartingPick(Collection<FlowNode> starts, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity parent, boolean createInstance, GenerationProperties gp) throws BPELException, BPMNException {
        PickImpl pick = new PickImpl(new TPick(), (BPELElement)parent);
        pick.setCreateInstance(createInstance);
        this.addActivityInParent((BPELElement)pick, (BPELElement)parent);
        for (FlowNode fn : starts) {
            if (fn instanceof CatchEvent) {
                CatchEvent e = (CatchEvent)fn;
                EventDefinition ed = BPELGeneratorHelper.getEventDefinition((WithEventDefinition)e, gp.getBPMNDefinitions());
                if (ed instanceof MessageEventDefinition) {
                    this.generateOnMessage(fn, ((MessageEventDefinition)ed).getOperationRef(), ((CatchEvent)fn).getDataOutputAssociation(), null, (ItemAwareElement[])e.getDataOutput(), (Pick)pick, gp);
                    continue;
                }
                this.generateOnAlarm(fn, (TimerEventDefinition)ed, (Pick)pick, gp);
                continue;
            }
            if (fn instanceof ReceiveTask) {
                this.generateOnMessage((ReceiveTask)fn, (Pick)pick, gp);
                continue;
            }
            if (fn instanceof EventBasedGateway) {
                return this.generatePick((EventBasedGateway)fn, parent, gp);
            }
            throw new BPMNException("A BPEL process should start with catch events or receive tasks. " + fn.getClass());
        }
        return pick;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generatePick(EventBasedGateway gateway, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity parent, GenerationProperties gp) throws BPELException, BPMNException {
        PickImpl pick = new PickImpl(new TPick(), (BPELElement)parent);
        pick.setCreateInstance(false);
        this.addActivityInParent((BPELElement)pick, (BPELElement)parent);
        FlowElement loopExit = null;
        if (gp.isLoopDiverger((Gateway)gateway)) {
            loopExit = gp.getLoopExit((Gateway)gateway);
        }
        for (FlowNode fn : gateway.getOutgoingFlowNodes()) {
            OnMessage e = null;
            if (fn instanceof IntermediateCatchEvent) {
                CatchEvent event = (CatchEvent)fn;
                EventDefinition ed = BPELGeneratorHelper.getEventDefinition((WithEventDefinition)event, gp.getBPMNDefinitions());
                if (ed instanceof MessageEventDefinition) {
                    e = this.generateOnMessage(fn, ((MessageEventDefinition)ed).getOperationRef(), ((IntermediateCatchEvent)fn).getDataOutputAssociation(), null, (ItemAwareElement[])event.getDataOutput(), (Pick)pick, gp);
                } else {
                    if (!(ed instanceof TimerEventDefinition)) throw new BPMNException("An event based gateway should be connected to intermediate message catching events or to receive tasks.");
                    e = this.generateOnAlarm(fn, (TimerEventDefinition)ed, (Pick)pick, gp);
                }
            } else {
                if (!(fn instanceof ReceiveTask)) throw new BPMNException("An event based gateway should be connected to intermediate message catching events or to receive tasks.");
                e = this.generateOnMessage((ReceiveTask)fn, (Pick)pick, gp);
            }
            if (loopExit == null || !loopExit.equals(fn)) continue;
            BPELVariable<?> var = this.createOrFindBooleanVariable((FlowElement)gateway, gp);
            AssignImpl assign = new AssignImpl(new TAssign(), (BPELElement)e);
            CopyImpl copy = new CopyImpl(new TCopy(), (BPELElement)assign);
            FromImpl from = new FromImpl(new TFrom(), (BPELElement)copy);
            from.setContent((Object)"true()");
            ToImpl to = new ToImpl(new TTo(), (BPELElement)copy);
            to.setContent((Object)("$" + var.getQName().getLocalPart()));
            copy.setFrom((From)from);
            copy.setTo((To)to);
            assign.addCopy((Copy)copy);
            this.addActivityInParent((BPELElement)assign, (BPELElement)e);
        }
        return pick;
    }

    private Scope generateScope(CallActivity callActi, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        QName qn = callActi.getCalledElement();
        Process proc = (Process)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)qn, Process.class);
        ScopeImpl scope = new ScopeImpl(new TScope(), (BPELElement)seqOrFlowOrScope);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)callActi, (BPELElement)scope);
        this.addActivityInParent((BPELElement)scope, (BPELElement)seqOrFlowOrScope);
        SequenceImpl seqMain = new SequenceImpl(new TSequence(), (BPELElement)scope);
        this.addActivityInParent((BPELElement)seqMain, (BPELElement)scope);
        Definitions defs = gp.getBPMNDefinitions();
        gp.setBPMNDefinitions(DefinitionsHelper.getParentDefinitions((TBaseElement)proc));
        List<FlowNode> starts = this.detectAllStartingNodes((WithFlowElements)proc, gp);
        if (starts.size() == 1) {
            this.generateActivity((FlowElement)starts.iterator().next(), (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seqMain, gp);
        } else if (starts.size() > 1) {
            this.generateStartingPick(starts, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seqMain, false, gp);
        }
        gp.setBPMNDefinitions(defs);
        this.generateNextActivity((FlowElement)callActi, (BPELElement)seqOrFlowOrScope, gp);
        return scope;
    }

    private While generateWhile(EventBasedGateway ebg, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        BPELBooleanExpressionImpl cond;
        TWhile model = new TWhile();
        WhileImpl while_ = new WhileImpl(model, (BPELElement)seqOrFlowOrScope);
        while_.setName(ebg.getName());
        gp.setCurrentWhileParent(seqOrFlowOrScope);
        BPELVariable<?> var = this.createOrFindBooleanVariable((FlowElement)ebg, gp);
        AssignImpl assign = new AssignImpl(new TAssign(), (BPELElement)seqOrFlowOrScope);
        CopyImpl copy = new CopyImpl(new TCopy(), (BPELElement)assign);
        FromImpl from = new FromImpl(new TFrom(), (BPELElement)copy);
        from.setContent((Object)"false()");
        ToImpl to = new ToImpl(new TTo(), (BPELElement)copy);
        to.setContent((Object)("$" + var.getQName().getLocalPart()));
        copy.setFrom((From)from);
        copy.setTo((To)to);
        assign.addCopy((Copy)copy);
        this.addActivityInParent((BPELElement)assign, (BPELElement)seqOrFlowOrScope);
        TBooleanExpr expr = new TBooleanExpr();
        try {
            cond = new BPELBooleanExpressionImpl((TExpression)expr, (BPELElement)while_);
        }
        catch (XPathExpressionException e) {
            throw new BPELException((Throwable)e);
        }
        String loopCondition = "not($" + var.getQName().getLocalPart() + ")";
        cond.setContent((Object)loopCondition);
        while_.setCondition((BPELBooleanExpression)cond);
        model.setCondition(expr);
        this.addActivityInParent((BPELElement)while_, (BPELElement)seqOrFlowOrScope);
        this.generatePick(ebg, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)while_, gp);
        return while_;
    }

    private void generateWhile(ExclusiveGateway eg, Set<SequenceFlow> loopingFlows, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        BPELBooleanExpressionImpl cond;
        System.out.println("*************While for : " + eg.getId());
        TWhile model = new TWhile();
        WhileImpl while_ = new WhileImpl(model, (BPELElement)seqOrFlowOrScope);
        while_.setName(eg.getName());
        gp.setCurrentWhileParent(seqOrFlowOrScope);
        TBooleanExpr expr = new TBooleanExpr();
        try {
            cond = new BPELBooleanExpressionImpl((TExpression)expr, (BPELElement)while_);
        }
        catch (XPathExpressionException e) {
            throw new BPELException((Throwable)e);
        }
        Process p = DefinitionsHelper.getParentProcess((FlowElement)eg);
        SequenceFlow nonlooper = null;
        for (SequenceFlow sf : p.getFlowElementsByClass(SequenceFlow.class)) {
            if (!sf.getSourceRef().getId().equals(eg.getId()) || loopingFlows.contains(sf)) continue;
            nonlooper = sf;
            break;
        }
        String loopCondition = "not(" + this.generateExpression(nonlooper.getConditionExpression().getTextContent(), gp) + ")";
        cond.setContent((Object)loopCondition);
        while_.setCondition((BPELBooleanExpression)cond);
        this.addActivityInParent((BPELElement)while_, (BPELElement)seqOrFlowOrScope);
        this.generateWhileInsideIf(eg, loopingFlows, (While)while_, model, gp);
    }

    private void generateWhileInsideIf(ExclusiveGateway eg, Collection<SequenceFlow> loopingFlows, While while_, TWhile model, GenerationProperties gp) throws BPELException, BPMNException {
        TSequence sm = new TSequence();
        SequenceImpl seq = new SequenceImpl(sm, (BPELElement)while_);
        while_.setActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq);
        model.setSequence(sm);
        ArrayList<FlowNode> activities = new ArrayList<FlowNode>();
        for (SequenceFlow sf : loopingFlows) {
            activities.add(sf.getTargetRef());
        }
        this.generateIf(activities, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq, (FlowElement)eg, eg.getDefault(), gp);
    }

    private Flow getCurrentFlow(BPELElement parent) {
        Flow res = null;
        if (parent != null) {
            res = parent instanceof Flow ? (Flow)parent : this.getCurrentFlow((BPELElement)((AbstractSchemaElementImpl)parent).getParent());
        }
        return res;
    }

    private If getCurrentIf(BPELElement parent) {
        If res = null;
        if (parent != null) {
            res = parent instanceof If ? (If)parent : this.getCurrentIf((BPELElement)((AbstractSchemaElementImpl)parent).getParent());
        }
        return res;
    }

    private Flow generateFlow(ParallelGateway gateway, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        FlowImpl flowA = null;
        System.out.println("found gateways: " + gateway.getId());
        List activities = gateway.getOutgoingFlowNodes();
        if (activities.size() > 0 && gateway.getIncomingFlowNodes().size() == 1) {
            flowA = new FlowImpl(new TFlow(), (BPELElement)seqOrFlowOrScope);
            this.addActivityInParent((BPELElement)flowA, (BPELElement)seqOrFlowOrScope);
            System.out.println("flow out size = " + activities.size());
            for (FlowNode elmt : activities) {
                SequenceImpl seq = new SequenceImpl(new TSequence(), (BPELElement)flowA);
                this.addActivityInParent((BPELElement)seq, (BPELElement)flowA);
                this.generateActivity((FlowElement)elmt, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq, gp);
            }
        } else if (!gp.getGatewaysAlreadyGenerated().contains(gateway)) {
            gp.getGatewaysAlreadyGenerated().add((Gateway)gateway);
            this.generateNextActivity((FlowElement)gateway, (BPELElement)((BPELElementImpl)this.getCurrentFlow((BPELElement)seqOrFlowOrScope)).getParent(), gp);
        }
        return flowA;
    }

    private If generateIf(List<FlowNode> activities, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, FlowElement forker, SequenceFlow defaultFlow, GenerationProperties gp) throws BPELException, BPMNException {
        IfImpl ifA = new IfImpl(new TIf(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)ifA, (BPELElement)seqOrFlowOrScope);
        System.out.println("if out size = " + activities.size());
        boolean first = true;
        for (FlowNode elmt : activities) {
            SequenceImpl seq = new SequenceImpl(new TSequence(), (BPELElement)ifA);
            this.generateActivity((FlowElement)elmt, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq, gp);
            try {
                System.out.println("elmt.getId().toString() = " + elmt.getId().toString());
                SequenceFlow sf = DefinitionsHelper.getSequenceFlow((WithFlowElements)DefinitionsHelper.getParentProcess((FlowElement)elmt), (String)forker.getId(), (String)elmt.getId());
                if (sf.hasConditionExpression()) {
                    BPELBooleanExpressionImpl exp;
                    if (first) {
                        exp = new BPELBooleanExpressionImpl((TExpression)new TBooleanExpr(), (BPELElement)ifA);
                        exp.setContent((Object)this.generateExpression(sf.getConditionExpression().getTextContent(), gp));
                        ifA.addIfActivity((BPELBooleanExpression)exp, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq);
                        first = false;
                        continue;
                    }
                    exp = new BPELBooleanExpressionImpl((TExpression)new TBooleanExpr(), (BPELElement)ifA);
                    exp.setContent((Object)this.generateExpression(sf.getConditionExpression().getTextContent(), gp));
                    ifA.addElseIfActivity((BPELBooleanExpression)exp, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq);
                    continue;
                }
                if (defaultFlow != null && defaultFlow.getTargetRef().getId().toString().equals(elmt.getId().toString())) {
                    ifA.setElseActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq);
                    continue;
                }
                throw new BPMNException("A sequence flow going out of an exclusive gateway must either have a condition or be the default of the gateway.");
            }
            catch (XPathExpressionException e) {
                throw new BPELException((Throwable)e);
            }
        }
        return ifA;
    }

    private If generateIf(ExclusiveGateway gateway, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        System.out.println("found gateways: " + gateway.getId());
        List activities = gateway.getOutgoingFlowNodes();
        if (activities.size() > 0 && gateway.getIncomingFlowNodes().size() == 1) {
            return this.generateIf(activities, seqOrFlowOrScope, (FlowElement)gateway, gateway.getDefault(), gp);
        }
        if (!gp.getGatewaysAlreadyGenerated().contains(gateway)) {
            gp.getGatewaysAlreadyGenerated().add((Gateway)gateway);
            this.generateNextActivity((FlowElement)gateway, (BPELElement)((BPELElementImpl)this.getCurrentIf((BPELElement)seqOrFlowOrScope)).getParent(), gp);
        }
        return null;
    }

    private com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity generateActivityFromTask(Task a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        Object res = null;
        if (a != null) {
            if (a.hasDataInputAssociation()) {
                this.generateAssign(a.getName(), (DataAssociation[])a.getDataInputAssociation(), seqOrFlowOrScope, gp);
            }
            res = a instanceof ServiceTask ? this.generateInvoke((ServiceTask)a, seqOrFlowOrScope, gp) : (a instanceof ReceiveTask ? this.generateReceive((ReceiveTask)a, seqOrFlowOrScope, gp) : (a instanceof SendTask ? (BPELGeneratorHelper.isReply((SendTask)a, gp.getCurrentParticipant(), gp.getBPMNDefinitions()) ? this.generateReply((SendTask)a, seqOrFlowOrScope, gp) : this.generateInOnlyInvoke((SendTask)a, seqOrFlowOrScope, gp)) : this.generateEmpty(a, seqOrFlowOrScope, gp)));
            if (a.hasDataOutputAssociation()) {
                this.generateAssign(a.getName(), (DataAssociation[])a.getDataOutputAssociation(), seqOrFlowOrScope, gp);
            }
            this.generateNextActivity((FlowElement)a, (BPELElement)seqOrFlowOrScope, gp);
        }
        return res;
    }

    private Receive generateReceive(ReceiveTask a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        assert (a != null);
        boolean instantiate = a.isInstantiate() || this.detectAllStartingNodes(DefinitionsHelper.getParentContainer((TFlowElement)a), gp).contains(a);
        Receive receive = a.getIoSpecification() != null ? this.generateReceive(a.getName(), instantiate, a.getOperationRef(), (ItemAwareElement[])a.getIoSpecification().getDataOutput(), seqOrFlowOrScope, gp) : this.generateReceive(a.getName(), instantiate, a.getOperationRef(), new ItemAwareElement[0], seqOrFlowOrScope, gp);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)a, (BPELElement)receive);
        return receive;
    }

    private Receive generateReceive(String name, boolean createInstance, QName operationRef, ItemAwareElement[] outputs, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        ReceiveImpl receive = new ReceiveImpl(new TReceive(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)receive, (BPELElement)seqOrFlowOrScope);
        receive.setName(name);
        receive.setCreateInstance(createInstance);
        Operation op = (Operation)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)operationRef, Operation.class);
        Interface itf = (Interface)op.getXmlObjectParent();
        if (itf.hasImplementationRef()) {
            receive.setInterface(itf.getImplementationRef());
            receive.setOperation(op.getImplementationRef().getLocalPart());
        } else {
            receive.setOperation(op.getName());
            receive.setInterface(new QName(gp.getBPMNDefinitions().getTargetNamespace(), itf.getName()));
        }
        receive.setPartnerLink(BPELGeneratorHelper.findPartnerLinkFromInterface(receive.getInterface(), gp.getBpelProcess(), gp.getPartnerLinkTypes().keySet()).getName());
        Message msgIn = (Message)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)op.getInMessageRef(), Message.class);
        BPELVariable<?> inputVariable = this.createOrFindVariableFromMessage(msgIn, outputs, gp);
        receive.setInputVariable(inputVariable.getQName().getLocalPart());
        gp.getInitializedVariables().add(inputVariable);
        return receive;
    }

    private Invoke generateInvoke(ServiceTask a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        Invoke invoke = a.getIoSpecification() != null ? this.generateInvoke(a.getName(), a.getOperationRef(), (ItemAwareElement[])a.getIoSpecification().getDataInput(), (ItemAwareElement[])a.getIoSpecification().getDataOutput(), seqOrFlowOrScope, gp) : this.generateInvoke(a.getName(), a.getOperationRef(), new ItemAwareElement[0], new ItemAwareElement[0], seqOrFlowOrScope, gp);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)a, (BPELElement)invoke);
        return invoke;
    }

    private Invoke generateInOnlyInvoke(SendTask a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        Invoke invoke = a.getIoSpecification() != null ? this.generateInOnlyInvoke(a.getName(), a.getOperationRef(), (ItemAwareElement[])a.getIoSpecification().getDataInput(), seqOrFlowOrScope, gp) : this.generateInOnlyInvoke(a.getName(), a.getOperationRef(), new ItemAwareElement[0], seqOrFlowOrScope, gp);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)a, (BPELElement)invoke);
        return invoke;
    }

    private Invoke generateInOnlyInvoke(String name, QName operationRef, ItemAwareElement[] input, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        InvokeImpl invoke = new InvokeImpl(new TInvoke(), (BPELElement)seqOrFlowOrScope);
        invoke.setName(name);
        Operation op = (Operation)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)operationRef, Operation.class);
        Interface itf = (Interface)op.getXmlObjectParent();
        if (itf.hasImplementationRef()) {
            invoke.setInterface(itf.getImplementationRef());
            invoke.setOperation(op.getImplementationRef().getLocalPart());
        } else {
            invoke.setOperation(op.getName());
            invoke.setInterface(new QName(gp.getBPMNDefinitions().getTargetNamespace(), itf.getName()));
        }
        invoke.setPartnerLink(BPELGeneratorHelper.findPartnerLinkFromInterface(invoke.getInterface(), gp.getBpelProcess(), gp.getPartnerLinkTypes().keySet()).getName());
        Message msgIn = (Message)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)op.getInMessageRef(), Message.class);
        BPELVariable<?> inputVariable = this.createOrFindVariableFromMessage(msgIn, input, gp);
        invoke.setInputVariable(inputVariable.getQName().getLocalPart());
        if (!gp.getInitializedVariables().contains(inputVariable)) {
            this.generateVariableInitializationAssign(inputVariable, seqOrFlowOrScope, gp);
        }
        this.addActivityInParent((BPELElement)invoke, (BPELElement)seqOrFlowOrScope);
        return invoke;
    }

    private Invoke generateInvoke(String name, QName operationRef, ItemAwareElement[] input, ItemAwareElement[] output, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        Invoke invoke = this.generateInOnlyInvoke(name, operationRef, input, seqOrFlowOrScope, gp);
        Operation op = (Operation)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)operationRef, Operation.class);
        Message msgOut = (Message)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)op.getOutMessageRef(), Message.class);
        BPELVariable<?> outputVar = this.createOrFindVariableFromMessage(msgOut, output, gp);
        invoke.setOutputVariable(outputVar.getQName().getLocalPart());
        gp.getInitializedVariables().add(outputVar);
        return invoke;
    }

    private Empty generateEmpty(Task a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        EmptyImpl empty = new EmptyImpl(new TEmpty(), (BPELElement)seqOrFlowOrScope);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)a, (BPELElement)empty);
        this.addActivityInParent((BPELElement)empty, (BPELElement)seqOrFlowOrScope);
        empty.setName(a.getName());
        return empty;
    }

    private Reply generateReply(SendTask a, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        Reply reply = a.getIoSpecification() != null ? this.generateReply(a.getName(), a.getOperationRef(), (ItemAwareElement[])a.getIoSpecification().getDataInput(), seqOrFlowOrScope, gp) : this.generateReply(a.getName(), a.getOperationRef(), new ItemAwareElement[0], seqOrFlowOrScope, gp);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)a, (BPELElement)reply);
        return reply;
    }

    private Reply generateReply(String name, QName operationRef, ItemAwareElement[] inputs, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        ReplyImpl reply = new ReplyImpl(new TReply(), (BPELElement)seqOrFlowOrScope);
        reply.setName(name);
        Operation op = (Operation)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)operationRef, Operation.class);
        Interface itf = (Interface)op.getXmlObjectParent();
        if (itf.hasImplementationRef()) {
            reply.setInterface(itf.getImplementationRef());
            reply.setOperation(op.getImplementationRef().getLocalPart());
        } else {
            reply.setOperation(op.getName());
            reply.setInterface(new QName(gp.getBPMNDefinitions().getTargetNamespace(), itf.getName()));
        }
        reply.setPartnerLink(BPELGeneratorHelper.findPartnerLinkFromInterface(reply.getInterface(), gp.getBpelProcess(), gp.getPartnerLinkTypes().keySet()).getName());
        Message msg = (Message)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)op.getOutMessageRef(), Message.class);
        BPELVariable<?> var = this.createOrFindVariableFromMessage(msg, inputs, gp);
        reply.setOutputVariable(var.getQName().getLocalPart());
        if (!gp.getInitializedVariables().contains(var)) {
            this.generateVariableInitializationAssign(var, seqOrFlowOrScope, gp);
        }
        this.addActivityInParent((BPELElement)reply, (BPELElement)seqOrFlowOrScope);
        return reply;
    }

    private void addActivityInParent(BPELElement child, BPELElement seqOrFlowOrScope) throws BPELException {
        if (seqOrFlowOrScope instanceof Sequence) {
            ((Sequence)seqOrFlowOrScope).addActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else if (seqOrFlowOrScope instanceof Flow) {
            ((Flow)seqOrFlowOrScope).addActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else if (seqOrFlowOrScope instanceof OnMessage) {
            ((OnMessage)seqOrFlowOrScope).setActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else if (seqOrFlowOrScope instanceof OnAlarm) {
            ((OnAlarm)seqOrFlowOrScope).setActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else if (seqOrFlowOrScope instanceof Pick) {
            if (child instanceof OnAlarm) {
                ((Pick)seqOrFlowOrScope).addOnAlarm((OnAlarm)child);
            } else if (child instanceof OnMessage) {
                ((Pick)seqOrFlowOrScope).addOnMessage((OnMessage)child);
            }
        } else if (seqOrFlowOrScope instanceof While) {
            ((While)seqOrFlowOrScope).setActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else if (seqOrFlowOrScope instanceof Scope) {
            ((Scope)seqOrFlowOrScope).setActivity((com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)child);
        } else {
            throw new BPELException("Sorry but this type of element is not handled yet : " + seqOrFlowOrScope.getClass());
        }
    }

    private Assign generateAssign(String activityName, DataAssociation[] dataAssociations, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        AssignImpl assign = null;
        if (dataAssociations.length > 0) {
            assign = new AssignImpl(new TAssign(), (BPELElement)seqOrFlowOrScope);
            for (DataAssociation asso : dataAssociations) {
                for (ItemAwareElement iae : asso.getSourceRef()) {
                    this.createOrFindVariableFromItemAwareElement(iae, gp);
                }
                BPELVariable<?> var = this.createOrFindVariableFromItemAwareElement(asso.getTargetRef(), gp);
                if (asso.hasAssignment()) {
                    gp.getInitializedVariables().add(var);
                }
                for (Assignment a : asso.getAssignment()) {
                    CopyImpl copy = new CopyImpl(new TCopy(), (BPELElement)assign);
                    FromImpl from = new FromImpl(new TFrom(), (BPELElement)copy);
                    from.setContent((Object)this.generateExpression(a.getFrom().getTextContent(), gp));
                    copy.setFrom((From)from);
                    ToImpl to = new ToImpl(new TTo(), (BPELElement)copy);
                    to.setContent((Object)this.generateExpression(a.getTo().getTextContent(), gp));
                    copy.setTo((To)to);
                    assign.addCopy((Copy)copy);
                }
                if (!asso.hasTransformation()) continue;
                System.out.println("WARNING : the transformations defined in BPMN dataAssociations are not handled yet.");
            }
            this.addActivityInParent((BPELElement)assign, (BPELElement)seqOrFlowOrScope);
        }
        return assign;
    }

    private void generateVariableInitializationAssign(BPELVariable<?> variable, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException, BPMNException {
        org.w3c.dom.Document d;
        AssignImpl assign = new AssignImpl(new TAssign(), (BPELElement)seqOrFlowOrScope);
        CopyImpl copy = new CopyImpl(new TCopy(), (BPELElement)assign);
        FromImpl from = new FromImpl(new TFrom(), (BPELElement)copy);
        from.setKind(FromAndTo.Kind.LITERAL);
        LiteralImpl literal = new LiteralImpl(new TLiteral(), (BPELElement)from);
        from.setLiteral((Literal)literal);
        com.ebmwebsourcing.easyschema10.api.element.Element elt = gp.getBPMNDefinitions().findImportedElement(variable.getElement());
        Element jdomElt = XSD2XML.newInstance().generateElement(elt, (XmlObject)SchemaHelper.findParentSchema((XmlObject)elt), (Object)"?");
        try {
            d = new DOMOutputter().output(new Document(jdomElt));
        }
        catch (JDOMException e) {
            e.printStackTrace();
            throw new BPELException((Throwable)e);
        }
        literal.setContent(d.getDocumentElement());
        ToImpl to = new ToImpl(new TTo(), (BPELElement)copy);
        to.setContent((Object)("$" + variable.getQName().getLocalPart()));
        copy.setFrom((From)from);
        copy.setTo((To)to);
        assign.addCopy((Copy)copy);
        this.addActivityInParent((BPELElement)assign, (BPELElement)seqOrFlowOrScope);
        gp.getInitializedVariables().add(variable);
    }

    private String generateExpression(String xpathExpression, GenerationProperties gp) {
        String result = xpathExpression;
        for (String associationExtrmityId : gp.getVariableMapping().keySet()) {
            result = result.replace("$" + associationExtrmityId, "$" + gp.getVariableMapping().get(associationExtrmityId));
        }
        return result;
    }

    private BPELVariable<?> createOrFindVariableFromItemAwareElement(ItemAwareElement iae, GenerationProperties gp) throws BPMNException {
        ItemDefinition itemDef = (ItemDefinition)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)iae.getItemSubjectRef(), ItemDefinition.class);
        BPELVariable<?> var = this.createOrFindVariableFromItemDefinition(((BaseElement)iae).getId(), itemDef, gp);
        gp.getVariableMapping().put(((BaseElement)iae).getId(), var.getQName().getLocalPart());
        return var;
    }

    private BPELVariable<?> createOrFindVariableFromItemDefinition(String name, ItemDefinition itemDef, GenerationProperties gp) {
        QName element = itemDef.getStructureRef();
        gp.getElementsToImport().add(element);
        String varName = BPELGeneratorHelper.getVariableName(name);
        for (BPELVariable var : gp.getBpelProcess().getVariables()) {
            if (var.getElement() == null || !var.getElement().equals(element) || !var.getQName().getLocalPart().equals(varName)) continue;
            return var;
        }
        BPELElementVariable var = gp.getBpelProcess().createBPELElementVariable(varName, element, BPELElementVariable.VariableType.ELEMENT);
        return var;
    }

    private OnMessage generateOnMessage(ReceiveTask rt, Pick pick, GenerationProperties gp) throws BPMNException, BPELException {
        if (rt.getIoSpecification() != null) {
            return this.generateOnMessage((FlowNode)rt, rt.getOperationRef(), rt.getDataOutputAssociation(), rt.getDataInputAssociation(), (ItemAwareElement[])rt.getIoSpecification().getDataOutput(), pick, gp);
        }
        return this.generateOnMessage((FlowNode)rt, rt.getOperationRef(), rt.getDataOutputAssociation(), rt.getDataInputAssociation(), new ItemAwareElement[0], pick, gp);
    }

    private OnMessage generateOnMessage(FlowNode fn, QName operationRef, DataOutputAssociation[] doas, DataInputAssociation[] dias, ItemAwareElement[] output, Pick pick, GenerationProperties gp) throws BPELException, BPMNException {
        OnMessageImpl onMessage = new OnMessageImpl(new TOnMessage(), (BPELElementImpl)pick);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)fn, (BPELElement)onMessage);
        this.addActivityInParent((BPELElement)onMessage, (BPELElement)pick);
        Operation op = (Operation)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)operationRef, Operation.class);
        Interface itf = (Interface)op.getXmlObjectParent();
        if (itf.hasImplementationRef()) {
            onMessage.setInterface(itf.getImplementationRef());
            onMessage.setOperation(op.getImplementationRef().getLocalPart());
        } else {
            onMessage.setOperation(op.getName());
            onMessage.setInterface(new QName(gp.getBPMNDefinitions().getTargetNamespace(), itf.getName()));
        }
        onMessage.setPartnerLink(BPELGeneratorHelper.findPartnerLinkFromInterface(onMessage.getInterface(), gp.getBpelProcess(), gp.getPartnerLinkTypes().keySet()).getName());
        Message msg = (Message)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)op.getInMessageRef(), Message.class);
        BPELVariable<?> var = this.createOrFindVariableFromMessage(msg, output, gp);
        onMessage.setInputVariable(var.getQName().getLocalPart());
        gp.getInitializedVariables().add(var);
        SequenceImpl seq = new SequenceImpl(new TSequence(), (BPELElement)onMessage);
        if (dias != null) {
            this.generateAssign(fn.getName(), (DataAssociation[])dias, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq, gp);
        }
        if (doas != null) {
            this.generateAssign(fn.getName(), (DataAssociation[])doas, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity)seq, gp);
        }
        this.generateNextActivity((FlowElement)fn, (BPELElement)seq, gp);
        if (!seq.getActivities().isEmpty()) {
            this.addActivityInParent((BPELElement)seq, (BPELElement)onMessage);
        }
        return onMessage;
    }

    private OnAlarm generateOnAlarm(FlowNode fn, TimerEventDefinition ed, Pick pick, GenerationProperties gp) throws BPELException, BPMNException {
        BPELDeadLineExpressionImpl exp;
        OnAlarmImpl alarm = new OnAlarmImpl(new TOnAlarmPick(), (BPELElementImpl)pick);
        ExtensionAdapter.getInstance().adaptExtensions((BaseElement)fn, (BPELElement)alarm);
        this.addActivityInParent((BPELElement)alarm, (BPELElement)pick);
        if (ed.hasTimeDate()) {
            exp = new BPELDeadLineExpressionImpl(new TDeadlineExpr(), (BPELElement)alarm);
            exp.setContent((Object)ed.getTimeDate().getTextContent());
            alarm.setUntil((BPELDeadLineExpression)exp);
        } else if (ed.hasTimeDuration()) {
            exp = new BPELDurationExpressionImpl(new TDurationExpr(), (BPELElement)alarm);
            exp.setContent((Object)ed.getTimeDuration().getTextContent());
            alarm.setFor((BPELDurationExpression)exp);
        } else {
            if (ed.hasTimeCycle()) {
                throw new BPMNException("No BPEL Activity corresponds to a BPMN Timer Event with a cycle Timer Event Definition.");
            }
            throw new BPMNException("A timer definition must have its Duration, its Date or its Cycle set.");
        }
        SequenceImpl seq = new SequenceImpl(new TSequence(), (BPELElement)alarm);
        this.generateNextActivity((FlowElement)fn, (BPELElement)seq, gp);
        if (!seq.getActivities().isEmpty()) {
            this.addActivityInParent((BPELElement)seq, (BPELElement)alarm);
        }
        return alarm;
    }

    private BPELVariable<?> createOrFindVariableFromMessage(Message message, ItemAwareElement[] data, GenerationProperties gp) throws BPMNException {
        for (ItemAwareElement iae : data) {
            if (!iae.getItemSubjectRef().equals(message.getItemRef())) continue;
            return this.createOrFindVariableFromItemAwareElement(iae, gp);
        }
        ItemDefinition itemDef = (ItemDefinition)DefinitionsHelper.findBPMNObject((Definitions)gp.getBPMNDefinitions(), (QName)message.getItemRef(), ItemDefinition.class);
        return this.createOrFindVariableFromItemDefinition(message.getName(), itemDef, gp);
    }

    private BPELVariable<?> createOrFindBooleanVariable(FlowElement fe, GenerationProperties gp) throws BPMNException {
        String varName = BPELGeneratorHelper.getVariableName(fe.getId());
        for (BPELVariable var : gp.getBpelProcess().getVariables()) {
            if (!var.getQName().getLocalPart().equals(varName)) continue;
            return var;
        }
        return gp.getBpelProcess().createBPELElementVariable(varName, new QName("http://www.w3.org/2001/XMLSchema", "boolean"), BPELElementVariable.VariableType.TYPE);
    }

    private void addDescriptionImport(BPELProcess p, com.ebmwebsourcing.easywsdl11.api.element.Definitions desc) {
        ImportImpl imp = new ImportImpl(new TImport(), (BPELElement)p);
        imp.setImportType(URI.create("http://schemas.xmlsoap.org/wsdl/"));
        imp.setLocation(URI.create(desc.getName() + ".wsdl"));
        imp.setNamespace(URI.create(desc.getTargetNamespace()));
        imp.setDescription((Description)Factory.getInstance().wrap((XmlObject)desc));
        p.addImport((com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import)imp);
    }

    private void addSchemaImport(BPELProcess p, Schema schema, String location) {
        ImportImpl imp = new ImportImpl(new TImport(), (BPELElement)p);
        imp.setImportType(URI.create("http://www.w3.org/2001/XMLSchema"));
        imp.setLocation(URI.create(location));
        imp.setNamespace(URI.create(schema.getTargetNamespace()));
        imp.setSchema2(schema);
        p.addImport((com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import)imp);
    }
}

