/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.stream;

import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.stream.StreamHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class StreamHelperTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyByteArrayStreams() {
        byte[] testByteArray = "foo".getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(testByteArray);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            StreamHelper.copy((InputStream)inputStream, (OutputStream)outputStream);
            Assert.assertArrayEquals((byte[])testByteArray, (byte[])outputStream.toByteArray());
        }
        finally {
            IOHelper.close((Closeable)inputStream);
            IOHelper.close((Closeable)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyBuffuredStreams() {
        byte[] testByteArray = "foo".getBytes();
        BufferedInputStream bufInputStream = new BufferedInputStream(new ByteArrayInputStream(testByteArray));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufOutputStream = new BufferedOutputStream(outputStream);
        try {
            StreamHelper.copy((InputStream)bufInputStream, (OutputStream)bufOutputStream);
            Assert.assertArrayEquals((byte[])testByteArray, (byte[])outputStream.toByteArray());
        }
        finally {
            IOHelper.close((Closeable)bufInputStream);
            IOHelper.close((Closeable)bufOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyBuffuredInputStreamsToByteArrayOutputStream() {
        byte[] testByteArray = "foo".getBytes();
        BufferedInputStream bufInputStream = new BufferedInputStream(new ByteArrayInputStream(testByteArray));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            StreamHelper.copy((InputStream)bufInputStream, (OutputStream)outputStream);
            Assert.assertArrayEquals((byte[])testByteArray, (byte[])outputStream.toByteArray());
        }
        finally {
            IOHelper.close((Closeable)bufInputStream);
            IOHelper.close((Closeable)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyByteArrayInputStreamsToBufferedOutputStream() {
        byte[] testByteArray = "foo".getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(testByteArray);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufOutputStream = new BufferedOutputStream(outputStream);
        try {
            StreamHelper.copy((InputStream)inputStream, (OutputStream)bufOutputStream);
            Assert.assertArrayEquals((byte[])testByteArray, (byte[])outputStream.toByteArray());
        }
        finally {
            IOHelper.close((Closeable)inputStream);
            IOHelper.close((Closeable)bufOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBytesFromByteArrayInputStreams() {
        byte[] testByteArray = "foo".getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(testByteArray);
        try {
            Assert.assertArrayEquals((byte[])testByteArray, (byte[])StreamHelper.getBytes((InputStream)inputStream));
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBytesFromBufferedInputStreams() {
        byte[] testByteArray = "foo".getBytes();
        BufferedInputStream bufInputStream = new BufferedInputStream(new ByteArrayInputStream(testByteArray));
        try {
            Assert.assertArrayEquals((byte[])testByteArray, (byte[])StreamHelper.getBytes((InputStream)bufInputStream));
        }
        finally {
            IOHelper.close((Closeable)bufInputStream);
        }
    }

    @Test
    public void testToString() throws IOException {
        StringBuilder bigStringBuilder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            bigStringBuilder.append("ALJAFMKLJAMLFJAMLJFALMJFA \t MLJFMAJFMAJFMJ \n");
        }
        String originalString = bigStringBuilder.toString();
        ByteArrayInputStream is = new ByteArrayInputStream(originalString.getBytes());
        Assert.assertEquals((Object)originalString, (Object)StreamHelper.getString((InputStream)is));
    }
}

