/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema10.api;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;

public class SchemaHelperTest {
    @Test
    public void testIsTypeDerivedFromIntegerWithBuiltinSchemaIntegerTypes() throws Exception {
        for (String typeName : new String[]{"integer", "nonPositiveInteger", "long", "nonNegativeInteger", "negativeInteger", "int", "unsignedLong", "positiveInteger", "short", "unsignedInt", "byte", "unsignedShort", "unsignedByte"}) {
            Assert.assertTrue((boolean)SchemaHelper.isTypeDerivedFromInteger((XmlObject)SchemaOfSchemas.getSchema(), (QName)new QName("http://www.w3.org/2001/XMLSchema", typeName)));
        }
    }

    @Test
    public void testIsTypeDerivedFromIntegerWithBuiltinSchemaNonIntegerTypes() throws Exception {
        for (String typeName : new String[]{"double", "decimal", "normalizedString", "dateTime", "string"}) {
            Assert.assertFalse((boolean)SchemaHelper.isTypeDerivedFromInteger((XmlObject)SchemaOfSchemas.getSchema(), (QName)new QName("http://www.w3.org/2001/XMLSchema", typeName)));
        }
    }

    @Test
    public void testFindAllBuiltInTypesByQName() throws Exception {
        for (String typeName : new String[]{"anyType", "anySimpleType", "duration", "dateTime", "time", "date", "gYearMonth", "gYear", "gMonthDay", "gDay", "gMonth", "boolean", "base64Binary", "hexBinary", "float", "double", "anyURI", "QName", "NOTATION", "string", "decimal", "normalizedString", "token", "language", "Name", "NMTOKEN", "NCName", "NMTOKENS", "ID", "IDREF", "ENTITY", "IDREFS", "ENTITIES", "integer", "nonPositiveInteger", "long", "nonNegativeInteger", "negativeInteger", "int", "unsignedLong", "positiveInteger", "short", "unsignedInt", "byte", "unsignedShort", "unsignedByte"}) {
            Assert.assertNotNull((Object)SchemaHelper.findTypeByQName((XmlObject)SchemaOfSchemas.getSchema(), (QName)new QName("http://www.w3.org/2001/XMLSchema", typeName)));
        }
    }
}

