package com.ebmwebsourcing.easyschema10.api;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.element.SimpleType;
import com.ebmwebsourcing.easyschema10.api.type.Type;

public final class SchemaHelper {

    private SchemaHelper() {
    }


    private static final <X extends XmlObjectNode> X doSelectSingleXmlObjectNode(
            XmlObject xmlObjectContextNode, String xpathStr,
            Class<X> resultInterfaceClass) {
        XmlObjectXPathEvaluator xpathEvaluator = xmlObjectContextNode.getXmlContext()
        .createXPathEvaluator();
        try {
            X result = xpathEvaluator
                    .selectSingleXmlObjectNode(xmlObjectContextNode,
                            String.format(
                                    xpathStr), 
                                    resultInterfaceClass);
            return result;
        } catch (XPathExpressionException xee) {
            throw new UncheckedException(xee);
        }        
    }
    
    private static <X extends XmlObjectNode> X[] doSelectXmlObjectNodes(
            XmlObject xmlObjectContextNode, String xpathStr,
            Class<X> resultInterfaceClass) {
        XmlObjectXPathEvaluator xpathEvaluator = xmlObjectContextNode.getXmlContext()
        .createXPathEvaluator();
        try {
            X[] result = xpathEvaluator
                    .selectXmlObjectNodes(xmlObjectContextNode,
                            String.format(
                                    xpathStr), 
                                    resultInterfaceClass);
            return result;
        } catch (XPathExpressionException xee) {
            throw new UncheckedException(xee);
        }        
    }
    

    /**
     * Get parent {@link Schema}.
     * 
     * @return Closest {@link Schema} object in ancestors hierarychy, or {@code null}
     *  if no such ancestor.
     */
    public static Schema findParentSchema(XmlObject contextObject) {
        XmlObject current = contextObject;
        while (current != null) {
            if (current instanceof Schema) return (Schema) current;
            current = current.getXmlObjectParent();
        }
        return null;
    }
    
    
    public static Type[] findTypes(XmlObject contextXmlObject) {
        return doSelectXmlObjectNodes(contextXmlObject, 
                String.format(
                "//*[(local-name() = 'simpleType') or (local-name() = 'complexType')][@name]"), 
                Type.class);
    }
    
    public static Type findTypeByQName(XmlObject contextXmlObject, QName typeQName) {
        if (Constants.XMLSCHEMA_NS_URI.equals(typeQName.getNamespaceURI())) {
            SimpleType builtInType = SchemaOfSchemas.getSchema().getSimpleTypeByName(typeQName.getLocalPart());
            return builtInType;
        }
        
        return doSelectSingleXmlObjectNode(contextXmlObject, 
                String.format(
                "//*[(local-name() = 'simpleType') or (local-name() = 'complexType')][@name = '%s'][ancestor::*/@targetNamespace = '%s']",
                typeQName.getLocalPart(), typeQName.getNamespaceURI()), Type.class);
        
    }

    
    public static Element[] findElements(XmlObject contextXmlObject) {
        return doSelectXmlObjectNodes(contextXmlObject, 
                String.format("//xs:element[@name][parent::xs:schema]"),
                Element.class);
        
    }
    
    
    public static Element findElementByQName(XmlObject contextXmlObject, QName elementQName) {
        return doSelectSingleXmlObjectNode(contextXmlObject, 
                String.format(
                        "//xs:element[@name = '%s']" + 
                        (elementQName.getNamespaceURI().isEmpty() ? "" : "[ancestor::xs:schema/@targetNamespace = '%s']"),
                        elementQName.getLocalPart(), elementQName.getNamespaceURI()), 
                        Element.class);        
    }


        
    
}
