/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.registry.ProcessInstanceRegistry;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.ServiceManager;
import com.ebmwebsourcing.easyviper.core.api.engine.time.TimerFinishedEvent;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.api.tools.PoolOfProcessForkers;
import com.ebmwebsourcing.easyviper.core.impl.engine.ProcessImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.ServiceManagerImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import com.ebmwebsourcing.easyviper.extended.service.autoflush.impl.AutoFlushMessageServiceImpl;
import com.ebmwebsourcing.easyviper.extended.service.autotrash.api.AutoTrashProcessService;
import com.ebmwebsourcing.easyviper.extended.service.autotrash.impl.AutoTrashProcessServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.osoa.sca.annotations.Property;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;
import org.ow2.frascati.tinfi.control.content.SCAExtendedContentController;

@Scope(value="COMPOSITE")
@Service(value={Engine.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class EngineImpl
extends SCAComponentImpl
implements Engine {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(EngineImpl.class.getName());
    @Reference(name="externalEnv", required=false)
    protected ExternalEnvironment externalEnvironment;
    @Reference(name="model", required=false)
    private Model model;
    @Property(name="processInstanceRegistry", required=true)
    private ProcessInstanceRegistry processInstanceRegistry = new MemoryProcessInstanceRegistryImpl(this);
    private Class internalMessageType;
    @Property(name="serviceManager", required=true)
    private ServiceManager serviceManager = new ServiceManagerImpl(this);
    private PoolOfProcessForkers poolOfProcessForkers = new PoolOfProcessForkers();

    private Component createEmptyProcess(String processName) throws CoreException {
        Component process = null;
        try {
            Process processDefinition;
            process = SCAHelper.getSCAHelper().createNewComponent(ProcessImpl.class.getName(), null);
            SCAHelper.getSCAHelper().addComponent(process, this.getComponent(), null);
            SCAContentController scacc = (SCAContentController)process.getFcInterface("/sca-content-controller");
            try {
                processDefinition = (Process)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            processDefinition.setName(processName);
            if (!this.log.getName().equals(EngineImpl.class.getName())) {
                processDefinition.setLog(this.log);
            }
            this.log.fine("Creation of the fractal process: " + processDefinition.getName());
            SCAHelper.getSCAHelper().startComponent(process);
            processDefinition = (Process)process.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return process;
    }

    public synchronized Process createNewEmptyProcessInstance(QName uniqueProcessName, ProcessDefinition processDefinition) throws CoreException {
        this.log.finest("start createNewEmptyProcessInstance");
        Process process = null;
        this.checkModel();
        Component processDefinitionComp = this.createEmptyProcess(uniqueProcessName.getLocalPart());
        try {
            process = (Process)processDefinitionComp.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
            throw new CoreException((Throwable)e);
        }
        if (this.model == null) {
            this.log.finest("store the process instance in registry in instance registry");
            ProcessKeyImpl key = new ProcessKeyImpl(uniqueProcessName, null, null);
            ArrayList<ProcessKeyImpl> keys = new ArrayList<ProcessKeyImpl>(1);
            keys.add(key);
            process.setProcessKeys(keys);
            this.processInstanceRegistry.storeProcessInstance((ProcessKey)key, process);
        } else {
            List keys = this.model.getRegistry().createKeys(processDefinition);
            this.log.finest("Number of keys: " + keys.size());
            for (ProcessKey key : keys) {
                this.log.finest("key put in process instances map: " + key);
                this.getProcessInstanceRegistry().storeProcessInstance(key, process);
            }
            process.setProcessKeys(keys);
        }
        this.log.finest("end of createNewEmptyProcessInstance");
        return process;
    }

    private void checkModel() throws CoreException {
        try {
            if (this.model == null) {
                Component coreComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
                Core core = (Core)coreComp.getFcInterface("service");
                this.model = core.getModel();
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    private void checkExternalEnvironment() throws CoreException {
        try {
            if (this.externalEnvironment == null) {
                Component coreComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
                Core core = (Core)coreComp.getFcInterface("service");
                this.externalEnvironment = core.getExternalEnvironment();
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public synchronized void accept(InternalMessage<?> internalMessage, ExternalContext context) throws CoreException {
        if (this.internalMessageType == null) {
            throw new CoreException("Configuration error: The type of internal message must be setted");
        }
        this.checkModel();
        Execution validExecution = this.acceptInternalMessage(internalMessage, context);
        if (validExecution == null) {
            this.log.finest("no process found => store the received message");
            AutoFlushMessageServiceImpl autoflush = (AutoFlushMessageServiceImpl)this.serviceManager.getService(AutoFlushMessageServiceImpl.class);
            autoflush.addMessagesInRegistry(internalMessage, context);
        } else {
            Endpoint endpoint = this.findEndpointFromMessage((Message<?>)internalMessage, validExecution.getParentScope().getProcess());
            if (validExecution.getParentScope().getProcess().getExternalContext(endpoint, internalMessage.getOperationName()) == null) {
                this.log.finest("set the context: " + context + " into process instance " + validExecution.getParentScope().getProcess().getName());
                validExecution.getParentScope().getProcess().addExternalContext(endpoint, internalMessage.getOperationName(), context);
            }
            this.restartExecutionAndParents(validExecution, context);
        }
    }

    private final Collection<String> getAllActiveThreadNames() {
        HashSet<String> result = new HashSet<String>();
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        for (Thread t : threads.keySet()) {
            result.add(t.getName());
        }
        return result;
    }

    private void restartExecutionAndParents(Execution execution, ExternalContext context) {
        Collection<String> threadNames = this.getAllActiveThreadNames();
        Execution.State execState = Execution.State.SUSPENDED;
        while (execution != null) {
            if (!threadNames.contains(String.valueOf(execution.hashCode())) && execState == Execution.State.SUSPENDED) {
                this.log.finest("Spawning (or respawning) thread for execution " + execution.getName());
                ThreadRunProcess processThread = new ThreadRunProcess(execution, context);
                processThread.start();
            }
            if ((execution = execution.getParentExecution()) == null) continue;
            execState = execution.getState();
        }
    }

    private final Execution findFirstAvailableExecution(InternalMessage<?> internalMessage, ExternalContext context) throws CoreException {
        Execution validExecution = null;
        if (this.processInstanceRegistry != null) {
            List processes = new ArrayList();
            this.log.finest("try to find an available instance");
            processes = this.processInstanceRegistry.getProcessInstances(internalMessage);
            if (processes != null) {
                this.log.finest("number of potential process: " + processes.size());
                String proc = null;
                for (Process p : processes) {
                    proc = proc == null ? p.getName() : String.valueOf(proc) + ", " + p.getName();
                }
                this.log.finest("potential process list : " + proc);
            } else {
                this.log.finest("number of potential process: 0");
            }
            if (processes != null && processes.size() > 0) {
                ArrayList<Execution> possibleExecution = new ArrayList<Execution>();
                boolean reinitOrSuspended = false;
                Iterator it = processes.iterator();
                while (it.hasNext()) {
                    Process process = (Process)it.next();
                    reinitOrSuspended = false;
                    try {
                        this.log.finest("test process: " + process.getName());
                        Endpoint endpoint = this.findEndpointFromMessage((Message<?>)internalMessage, process);
                        if (process.getParentExecution() != null && process.getParentExecution().getState() == Execution.State.ENDED) {
                            this.log.finest("reinit and restart an older instance: " + process.getName());
                            process.end(true);
                            process.removeExternalContext(endpoint, internalMessage.getOperationName());
                            process.run();
                        } else if (process.getParentExecution() == null) {
                            this.log.finest("reinit and restart an older instance: " + process.getName());
                            process.removeExternalContext(endpoint, internalMessage.getOperationName());
                            process.run();
                        }
                        reinitOrSuspended = true;
                    }
                    catch (CoreException e) {
                        process.setState(Process.State.PROCESS_UNSTABLE);
                        processes.remove(process);
                        it = processes.iterator();
                        AutoTrashProcessService autoTrash = (AutoTrashProcessService)this.serviceManager.getService(AutoTrashProcessServiceImpl.class);
                        autoTrash.addUninstableProcessInstance(process);
                    }
                    if (!reinitOrSuspended) continue;
                    try {
                        Execution exec = this.injectMessageInProcessInstance(process, internalMessage, context);
                        if (exec == null) continue;
                        this.log.finest("available instance found => restart the process " + process.getName());
                        process.setState(Process.State.PROCESS_ACTIVE);
                        possibleExecution.add(exec);
                        break;
                    }
                    catch (CoreException e) {
                        this.log.severe("Error injecting a message in process " + process.getName() + ": " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (possibleExecution.size() > 0) {
                    validExecution = (Execution)possibleExecution.get(0);
                }
            }
        }
        return validExecution;
    }

    private Execution acceptInternalMessage(InternalMessage<?> internalMessage, ExternalContext context) throws CoreException {
        Execution validExecution = this.findFirstAvailableExecution(internalMessage, context);
        if (validExecution == null) {
            this.log.finest("no available instance found");
            if (this.model != null) {
                ProcessKeyImpl key = new ProcessKeyImpl();
                key.setEndpoint(internalMessage.getEndpoint());
                key.setService(internalMessage.getService());
                ProcessDefinition definition = this.model.getRegistry().getProcessDefinition((ProcessKey)key);
                if (definition == null) {
                    throw new CoreException("Impossible to find definition corresponding to this key: " + key);
                }
                if (this.isCreateInstance(definition, internalMessage)) {
                    Process process = this.model.getCompiler().compile(definition);
                    if (process != null) {
                        this.log.finest("run the process...");
                        process.run();
                        this.log.finest("inject the message in process");
                        Execution exec = this.injectMessageInProcessInstance(process, internalMessage, context);
                        if (exec != null) {
                            validExecution = exec;
                        }
                    } else {
                        this.log.finest("no process definition found concerned by the received message: " + key);
                    }
                }
            }
        }
        return validExecution;
    }

    private Execution injectMessageInProcessInstance(Process process, InternalMessage<?> internalMessage, ExternalContext context) throws CoreException {
        Execution res = null;
        Map execs = process.getSuspendedExecutions();
        this.log.finest("list of execution to try: " + execs);
        for (Execution exec : execs.values()) {
            try {
                this.log.finest("try to inject message in process " + process.getName() + " using execution " + exec.getName());
                if (exec.getCurrentTarget() instanceof Node) {
                    Node node = exec.getCurrentTarget();
                    if (node.getBehaviour() instanceof ReceiverBehaviour) {
                        ReceiverBehaviour receiverBehaviour = (ReceiverBehaviour)node.getBehaviour();
                        if (receiverBehaviour.getMessage() == null) {
                            receiverBehaviour.setMessage(internalMessage);
                            this.log.finest("message setted in receive behaviour: " + receiverBehaviour.getName());
                            boolean accept = receiverBehaviour.accept(internalMessage, context);
                            this.log.finest("accepted by receiver: " + receiverBehaviour.getName() + " ? " + accept);
                            if (accept) {
                                res = exec;
                                break;
                            }
                            receiverBehaviour.setMessage(null);
                            continue;
                        }
                        this.log.finest("the receiver " + receiverBehaviour.getName() + " already contains a message");
                        continue;
                    }
                    throw new CoreException("Error: the node selected is not concerned by the received message " + node.getBehaviour().getName() + "::" + node.getClass().getCanonicalName());
                }
                throw new CoreException("Error: the execution selected is not concerned by the received message");
            }
            catch (CoreException e) {
                this.log.finest("Error in injectMessageInProcessInstance: " + e.getMessage());
            }
        }
        return res;
    }

    public void flushMessagesInRegistry() throws CoreException {
        this.log.finest("flush stored messages");
        AutoFlushMessageServiceImpl autoflush = (AutoFlushMessageServiceImpl)this.serviceManager.getService(AutoFlushMessageServiceImpl.class);
        autoflush.flushMessagesInRegistry();
    }

    public void setInternalMessageType(Class clazz) {
        this.internalMessageType = clazz;
    }

    public Class getInternalMessageType() {
        return this.internalMessageType;
    }

    public void sendTo(InternalMessage<?> message, Endpoint providerEndpoint, Map<Endpoint, Map<String, ExternalContext>> context) throws CoreException {
        ExternalContext ec;
        this.checkExternalEnvironment();
        if (this.externalEnvironment.getSenders() != null && this.externalEnvironment.getSenders().size() > 0) {
            this.log.finest("Context map : " + context);
            Map<String, ExternalContext> map = context.get(providerEndpoint);
            ec = null;
            if (map != null) {
                ec = map.get(message.getOperationName());
            }
            if (ec == null) {
                Collection<ExternalContext> coll2;
                assert (!context.isEmpty());
                Collection<Map<String, ExternalContext>> coll = context.values();
                if (!coll.isEmpty() && !(coll2 = coll.iterator().next().values()).isEmpty()) {
                    ec = coll2.iterator().next();
                }
            }
            assert (ec != null);
        } else {
            throw new CoreException("Senders does not exist!!!");
        }
        ((Sender)this.externalEnvironment.getSenders().get(0)).sendTo(message, providerEndpoint, ec);
    }

    public InternalMessage<?> sendSyncTo(InternalMessage<?> request, Endpoint providerEndpoint, Map<Endpoint, Map<String, ExternalContext>> context) throws CoreException {
        ExternalContext ec;
        InternalMessage res = null;
        this.checkExternalEnvironment();
        if (this.externalEnvironment.getSenders() != null && this.externalEnvironment.getSenders().size() > 0) {
            Collection<ExternalContext> coll2;
            Collection<Map<String, ExternalContext>> coll;
            Map<String, ExternalContext> map = context.get(providerEndpoint);
            ec = null;
            if (map != null) {
                ec = map.get(request.getOperationName());
            }
            if (ec == null && (coll = context.values()) != null && !coll.isEmpty() && (coll2 = coll.iterator().next().values()) != null && !coll2.isEmpty()) {
                ec = coll2.iterator().next();
            }
        } else {
            throw new CoreException("Senders does not exist!!!");
        }
        res = ((Sender)this.externalEnvironment.getSenders().get(0)).sendSyncTo(request, providerEndpoint, ec);
        return res;
    }

    public ProcessInstanceRegistry getProcessInstanceRegistry() {
        return this.processInstanceRegistry;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public void deleteProcess(Process process) throws CoreException {
        try {
            SCAExtendedContentController parentContentController = (SCAExtendedContentController)process.getParentExecution().getComponent().getFcInterface("/sca-content-controller");
            parentContentController.releaseFcContent((Object)process.getComponent(), true);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException("Delete process " + process.getName() + "failed. Caused by " + e.getMessage());
        }
    }

    public Core getCore() throws CoreException {
        Core res = null;
        try {
            Component coreComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            res = (Core)coreComp.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private boolean isCreateInstance(ProcessDefinition def, InternalMessage<?> mess) throws CoreException {
        return this.model.getRegistry().isCreateInstance(def, mess);
    }

    public PoolOfProcessForkers getPoolOfProcessForkers() {
        return this.poolOfProcessForkers;
    }

    public Endpoint findEndpointFromMessage(Message<?> mess, Process process) {
        Collection endpoints = process.getEndpoints().values();
        Iterator itEndpoints = endpoints.iterator();
        Endpoint endpoint = null;
        while (itEndpoints.hasNext()) {
            Endpoint current = (Endpoint)itEndpoints.next();
            if (current.getEndpointName() == null || current.getServiceName() == null || !current.getEndpointName().equalsIgnoreCase(mess.getEndpoint()) || !current.getServiceName().equals(mess.getService())) continue;
            endpoint = current;
            break;
        }
        return endpoint;
    }

    public Process findProcessFromName(String processInstanceName) {
        Process p = null;
        ProcessKeyImpl key = new ProcessKeyImpl();
        QName processDefinitionName = EngineImpl.extractProcessDefinitionName(processInstanceName);
        try {
            key = this.getCore().getModel().getRegistry().findProcessKey(processDefinitionName);
            List processInstances = this.getProcessInstanceRegistry().getProcessInstances((ProcessKey)key);
            for (Process process : processInstances) {
                if (!process.getName().equals(processInstanceName)) continue;
                p = process;
                break;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return p;
    }

    private static QName extractProcessDefinitionName(String processInstanceName) {
        int indexOf_ = processInstanceName.lastIndexOf("_");
        String valueOfQName = processInstanceName.substring(0, indexOf_);
        return QName.valueOf(valueOfQName);
    }

    public void onTimerFinish(TimerFinishedEvent e) throws CoreException {
        if (e.getException() != null) {
            throw new CoreException((Throwable)e.getException());
        }
        e.getWaitBehaviour().terminateWaiting();
        this.restartExecutionAndParents(e.getWaitBehaviour().getNode().getExecution(), null);
    }

    private class ThreadRunProcess
    extends Thread {
        private Execution validProcessOrExecution;
        private ExternalContext context;

        public ThreadRunProcess(Execution validProcessOrExecution, ExternalContext context) {
            super(String.valueOf(validProcessOrExecution.hashCode()));
            this.validProcessOrExecution = validProcessOrExecution;
            this.context = context;
        }

        @Override
        public void run() {
            try {
                if (this.validProcessOrExecution.isStepByStep()) {
                    this.validProcessOrExecution.runStepByStep();
                } else {
                    this.validProcessOrExecution.run();
                }
            }
            catch (Exception e) {
                if (e instanceof CoreException) {
                    try {
                        ((Sender)this.validProcessOrExecution.getParentScope().getProcess().getEngine().getCore().getExternalEnvironment().getSenders().get(0)).sendTo((CoreException)((Object)e), this.context);
                    }
                    catch (CoreException e1) {
                        this.validProcessOrExecution.setState(Execution.State.ENDED);
                        try {
                            this.validProcessOrExecution.end();
                        }
                        catch (CoreException e2) {
                            e1.printStackTrace();
                            EngineImpl.this.log.severe(e1.getMessage());
                        }
                        e1.printStackTrace();
                        EngineImpl.this.log.severe(e1.getMessage());
                    }
                }
                e.printStackTrace();
                EngineImpl.this.log.severe("exception while running process (No CoreException)... " + e.getMessage());
            }
        }
    }
}

