package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ExclusiveBehaviour;

@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=ExclusiveBehaviour.class,names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class ExclusiveBehaviourImpl extends AbstractBehaviourImpl implements ExclusiveBehaviour {
	
	private Logger log = Logger.getLogger(ExclusiveBehaviourImpl.class.getName());
	
	@Property(name="triggeringNodes", required=false)
	private Set<Node> triggeringNodes;
	
	@Property(name="alreadyNotified", required=false)
	private boolean alreadyNotified = false;
	

	@Override
	protected void executeOnEnded() throws CoreException {
		getNode().selectDefaultNextTarget();
	}

	@Override
	protected void executeOnInactive() throws CoreException {
		this.state = State.ACTIVITY_STARTED;
		alreadyNotified = false;

		if(triggeringNodes==null || triggeringNodes.isEmpty()) {
			this.state = State.ACTIVITY_ENDED;
			return;
		}
		
		try{
			SCAHelper.getSCAHelper().startComponentAndSubComponents(getNode().getExecution().getParentScope().getComponent());
		} catch(SCAException e) {
			throw new CoreException(e);
		}
		
		List<Node> nodes = new ArrayList<Node>();
		for(Node child : getNode().getChildNodes()) {
			for(Node triggeringNode : triggeringNodes) {
				if(triggeringNode.getName().equals(child.getName())) {
					nodes.add(child);
					break;
				}
			}
		}
 		getNode().getExecution().setNextExecutableElements(this, nodes);
	}
	
	@Override
	protected void executeOnStarted() throws CoreException {
		if(getNode().getExecution().getChildExecutions().isEmpty()) {
			//when the fastest child execution finished
			log.finest("End of exclusive behaviour.");
			this.state = State.ACTIVITY_ENDED;
		}
	}
	
	@Override
	public synchronized void onChildBehaviourNotification(Behaviour childBehaviour) throws CoreException {
		if(alreadyNotified) {
			return;
		}
		alreadyNotified = true;
		
		log.finest("Notification received from "+childBehaviour.getName());
		
		//cancel all the other child executions
		String execName = childBehaviour.getNode().getExecution().getName();
		for(Execution childExec : getNode().getExecution().getChildExecutions()) {
			if(!execName.equals(childExec.getName())) {
				log.finest(childExec.getName()+" has been cancelled");
				childExec.setState(Execution.State.CANCELLED);
				getNode().getExecution().removeChildExecution(childExec);
			}
		}
	}

}
