/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.Reference;
import org.objectweb.fractal.api.Component;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SequenceBehaviour;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=SequenceBehaviour.class,names="service")
public class SequenceBehaviourImpl extends AbstractBehaviourImpl implements
SequenceBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger
	.getLogger(SequenceBehaviourImpl.class.getName());


	@Override
	public String toString() {
		return "Sequence";
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	@Override
	protected void executeOnEnded() throws CoreException {
	}

	@Override
	protected void executeOnInactive() throws CoreException {
		this.log.finest("start sequence behaviour on node: "
				+ this.node.getName());
		this.state = State.ACTIVITY_STARTED;
		try {
			final List<Node> childs = this.node.getChildNodes();
			if ((childs != null) && (childs.size() > 0)) {

				// find first node
				Node firstNode = null;
				for (final Node node : childs) {

					// start the node component
					final Component nodeComp = SCAHelper.getSCAHelper()
					.getComponentByInterface(
							SCAHelper.getSCAHelper().getParent(
									this.getComponent()),
									//								(org.objectweb.fractal.api.Interface) node,
									(ServiceReference<?>) node,
					"service");
					if ((nodeComp != null)
							&& (!SCAHelper.getSCAHelper().isStarted(
									nodeComp))) {
						SCAHelper.getSCAHelper().startComponent(
								nodeComp);
					}

					if ((node.getIncomingNodes() == null)
							|| ((node.getIncomingNodes() != null) && (node
									.getIncomingNodes().size() == 0))) {
						firstNode = node;
						break;
					}
				}

				getNode().getExecution().setNextExecutableElements(this, firstNode);
			} else {
				this.state = State.ACTIVITY_ENDED;
			}
		} catch(SCAException e) {
			throw new CoreException(e);
		}
	}

	@Override
	protected void executeOnStarted() throws CoreException {
		this.log
		.finest("end sequence behaviour on node: "
				+ this.node.getName());
		this.state = State.ACTIVITY_ENDED;

	}
}
