/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.impl.marshalling.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.marshalling.factory.MessageFactory;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;

public class MessageFactoryImpl implements MessageFactory<ExternalMessage<?>, InternalMessage<?>> {

	private Class<? extends InternalMessage<?>> internalMsgClass;
	
	private Class<? extends ExternalMessage<?>> externalMsgClass;
	
	public MessageFactoryImpl(Class<? extends InternalMessage<?>> internalMsgClass, Class<? extends ExternalMessage<?>> externalMsgClass) {
		this.internalMsgClass = internalMsgClass;
		this.externalMsgClass = externalMsgClass;
	}
	
	public ExternalMessage<?> createExternalMessage() throws CoreException {
		ExternalMessage<?> res = null;
		try {
			final Constructor<?> c = this.externalMsgClass.getConstructors()[0];
			res =  (ExternalMessage<?>) c.newInstance();
		} catch (final IllegalArgumentException e) {
			throw new CoreException(e);
		} catch (final InstantiationException e) {
			throw new CoreException(e);
		} catch (final IllegalAccessException e) {
			throw new CoreException(e);
		} catch (final InvocationTargetException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public InternalMessage<?> createInternalMessage() throws CoreException  {
		InternalMessage<?> res = null;
		try {
			final Constructor<?> c = this.internalMsgClass.getConstructors()[0];
			res =  (InternalMessage<?>) c.newInstance();
		} catch (final IllegalArgumentException e) {			
			throw new CoreException(e);
		} catch (final InstantiationException e) {
			throw new CoreException(e);
		} catch (final IllegalAccessException e) {
			throw new CoreException(e);
		} catch (final InvocationTargetException e) {
			throw new CoreException(e);
		}
		return res;
	}

	

}
