/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.marshalling;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.marshalling.factory.InternalMessageFactoryImpl;
import com.ebmwebsourcing.easyviper.core.impl.marshalling.factory.VariableFactoryImpl;
import com.ebmwebsourcing.easyviper.core.impl.test.util.StringVariableImpl;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ViperVariableMarshallingTest {
    private Logger log = Logger.getLogger(this.getClass().getSimpleName());
    private static final String ns = "http://easyviper/test";

    private Variable createVariable() throws CoreException {
        Variable res = null;
        VariableFactoryImpl varFactory = new VariableFactoryImpl(StringVariableImpl.class);
        res = (Variable)varFactory.create();
        QName qnameTest = new QName(ns, "myVar");
        res.setQName(qnameTest);
        return res;
    }

    private InternalMessage<Element> createInternalMessage() throws CoreException, ParserConfigurationException {
        InternalMessage mess = null;
        InternalMessageFactoryImpl messFactory = new InternalMessageFactoryImpl();
        mess = (InternalMessage)messFactory.create();
        QName qnameTest = new QName(ns, "myVar");
        mess.setQName(qnameTest);
        mess.setEndpoint("myEndpoint");
        mess.setOperationName("myOperation");
        mess.setService(new QName(ns, "myService"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().newDocument();
        Element content = doc.createElementNS("urn:namespaceMessageContent", "content");
        doc.appendChild(content);
        Element root = doc.createElementNS("urn:namespaceMessageContent", "root");
        content.appendChild(root);
        Element node1 = doc.createElementNS("urn:namespaceMessageContent", "node1");
        node1.setTextContent("node1 text content");
        root.appendChild(node1);
        mess.setContent((Object)doc.getDocumentElement());
        return mess;
    }

    @Test
    public void testCreateMarshalling() {
        this.log.finest("Creation test ...");
        Variable var = null;
        try {
            var = this.createVariable();
        }
        catch (CoreException e) {
            e.printStackTrace();
            junit.framework.Assert.fail();
        }
        junit.framework.Assert.assertEquals((Object)new QName(ns, "myVar"), (Object)var.getQName());
    }

    @Test
    public void testWriteMarshalling() {
        Document doc = null;
        try {
            this.log.finest("write test");
            Variable var = this.createVariable();
            VariableFactoryImpl varFactory = new VariableFactoryImpl(StringVariableImpl.class);
            doc = varFactory.getDocument((Object)var);
            String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ns2:variable xmlns:ns2=\"http://ebmwebsourcing.com/easyviper/model/light\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n  <ns2:name xmlns=\"http://easyviper/test\">myVar</ns2:name>\n</ns2:variable>";
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedDoc, (String)XMLPrettyPrinter.prettyPrint((Document)doc)));
        }
        catch (CoreException e) {
            e.printStackTrace();
            junit.framework.Assert.fail();
        }
    }

    @Test
    public void testReadMarshalling() {
        VariableFactoryImpl varFactory = new VariableFactoryImpl(StringVariableImpl.class);
        Variable var = null;
        Document varAsDoc = null;
        try {
            var = this.createVariable();
            varAsDoc = varFactory.getDocument((Object)var);
            Variable varRes = (Variable)varFactory.read(varAsDoc);
            if (var == null) {
                junit.framework.Assert.fail((String)"var is null");
            }
            if (varRes == null) {
                junit.framework.Assert.fail((String)"varRes is null");
            }
            junit.framework.Assert.assertEquals((Object)var, (Object)varRes);
        }
        catch (CoreException e) {
            e.printStackTrace();
            junit.framework.Assert.fail();
        }
    }

    @Test
    public void testReadWithContent() {
        VariableFactoryImpl varFactory = new VariableFactoryImpl(StringVariableImpl.class);
        Variable var = null;
        Document varAsDoc = null;
        try {
            var = this.createVariable();
            InternalMessage<Element> mess = this.createInternalMessage();
            var.setValue(mess);
            varAsDoc = varFactory.getDocument((Object)var);
            System.out.println(XMLPrettyPrinter.prettyPrint((Document)varAsDoc));
            Variable varRes = (Variable)varFactory.read(varAsDoc);
            if (var == null) {
                junit.framework.Assert.fail((String)"var is null");
            }
            if (varRes == null) {
                junit.framework.Assert.fail((String)"varRes is null");
            }
            if (var.getValue() == null) {
                junit.framework.Assert.fail((String)"var.getValue is null");
            }
            if (varRes.getValue() == null) {
                junit.framework.Assert.fail((String)"varRes.getValue is null");
            }
            junit.framework.Assert.assertEquals((String)var.getQName().toString(), (String)varRes.getQName().toString());
        }
        catch (CoreException e) {
            e.printStackTrace();
            junit.framework.Assert.fail();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            junit.framework.Assert.fail();
        }
    }
}

