/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import com.ebmwebsourcing.easyviper.core.api.engine.monitoring.Monitor;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.monitoring.MonitorImpl;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.osoa.sca.annotations.Property;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={Process.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class ProcessImpl
extends ScopeImpl
implements Process {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(ProcessImpl.class.getName());
    @Property(name="keys", required=true)
    private List<ProcessKey> keys;
    @Property(name="externalContexts", required=false)
    private Map<Endpoint, Map<String, ExternalContext>> externalContexts;
    private Monitor monitor = new MonitorImpl();
    @Property(name="state", required=true)
    private Process.State state = Process.State.PROCESS_INACTIVE;
    private Assigner assigner = null;

    public ProcessImpl() throws CoreException {
        this.externalContexts = new HashMap<Endpoint, Map<String, ExternalContext>>();
    }

    public void run() throws CoreException {
        this.log.finest("run process");
        if (this.state == Process.State.PROCESS_INACTIVE || this.state == Process.State.PROCESS_ENDED) {
            this.getMonitor().reset();
            this.getMonitor().setStartTime(Calendar.getInstance().getTime());
        }
        this.state = Process.State.PROCESS_ACTIVE;
        try {
            this.createParentExecution();
            this.log.finest("start parent execution");
            if (!SCAHelper.getSCAHelper().isStarted(this.parentExecution)) {
                SCAHelper.getSCAHelper().startComponent(this.parentExecution);
            }
            this.log.finest("parent execution started");
            this.log.finest("run the execution");
            Execution exec = (Execution)this.parentExecution.getFcInterface("service");
            Thread.currentThread().setName(String.valueOf(exec.hashCode()));
            exec.run();
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        this.log.finest("end of process");
    }

    public void runStepByStep() throws CoreException {
        this.log.finest("run process");
        if (this.state == Process.State.PROCESS_INACTIVE || this.state == Process.State.PROCESS_ENDED) {
            this.getMonitor().reset();
            this.getMonitor().setStartTime(Calendar.getInstance().getTime());
        }
        this.state = Process.State.PROCESS_ACTIVE;
        try {
            this.createParentExecution();
            this.log.finest("start parent execution");
            if (!SCAHelper.getSCAHelper().isStarted(this.parentExecution)) {
                SCAHelper.getSCAHelper().startComponent(this.parentExecution);
            }
            this.log.finest("parent execution started");
            this.log.finest("run the execution");
            Execution exec = (Execution)this.parentExecution.getFcInterface("service");
            exec.runStepByStep();
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        this.log.finest("end of process");
    }

    public Execution createParentExecution() throws CoreException {
        Execution res = null;
        try {
            if (this.parentExecution == null) {
                this.log.finest("create parent execution");
                this.parentExecution = SCAHelper.getSCAHelper().createNewComponent(ExecutionImpl.class.getName(), null);
                SCAContentController scacc = (SCAContentController)this.parentExecution.getFcInterface("/sca-content-controller");
                try {
                    res = (Execution)scacc.getFcContent();
                }
                catch (ContentInstantiationException e) {
                    throw new CoreException((Throwable)e);
                }
                if (!this.log.getName().equals(ProcessImpl.class.getName())) {
                    res.setLog(this.log);
                }
                SCAHelper.getSCAHelper().addComponent(this.parentExecution, this.getComponent(), null);
                SCAHelper.getSCAHelper().changeName(this.parentExecution, "mainExec");
                if (this.initialNode == null) {
                    throw new CoreException("Initial node not setted");
                }
                this.linkInitialNodeAndExecution();
            }
            res = (Execution)this.parentExecution.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public Map<String, Execution> getSuspendedExecutions() throws CoreException {
        HashMap<String, Execution> res;
        block6: {
            res = new HashMap<String, Execution>();
            try {
                if (this.getParentExecution() != null && this.getParentExecution().getState().equals((Object)Execution.State.SUSPENDED)) {
                    res.putAll(this.getSuspendedExecutions(this.getParentExecution().getParentScope()));
                    break block6;
                }
                if (this.getParentExecution() != null) break block6;
                Execution main = this.createParentExecution();
                Component exec = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)main, "service");
                SCAHelper.getSCAHelper().startComponent(exec);
                try {
                    if (!res.containsKey(this.getParentExecution().getName())) {
                        res.put(this.getParentExecution().getName(), this.getParentExecution());
                    }
                }
                catch (CoreException coreException) {}
            }
            catch (SCAException e) {
                throw new CoreException((Throwable)e);
            }
        }
        return res;
    }

    private Map<String, Execution> getSuspendedExecutions(Scope parentScope) {
        HashMap<String, Execution> res = new HashMap<String, Execution>();
        try {
            this.log.finest("parentScope " + parentScope.getName());
            if (parentScope != null) {
                List receiveBehaviours = parentScope.findBehaviours(ReceiverBehaviour.class);
                this.log.finest("Number of receiver behaviours: " + receiveBehaviours.size());
                for (ReceiverBehaviour receiveBehaviour : receiveBehaviours) {
                    this.log.finest("receiver behaviour: " + receiveBehaviour.getName());
                    if (receiveBehaviour.getNode().getExecution() == null || !receiveBehaviour.getNode().getExecution().getState().equals((Object)Execution.State.SUSPENDED) || res.containsKey(receiveBehaviour.getNode().getExecution().getName())) continue;
                    this.log.finest("execution \"" + receiveBehaviour.getNode().getExecution().getName() + "\" of receiver behaviour \"" + receiveBehaviour.getName() + "\" is concerned execution.");
                    res.put(receiveBehaviour.getNode().getExecution().getName(), receiveBehaviour.getNode().getExecution());
                }
            }
        }
        catch (CoreException e) {
            this.log.severe("Error in getSuspendedExecutions: " + e.getMessage());
        }
        catch (NullPointerException ne) {
            this.log.severe("Error in getSuspendedExecutions (null pointer): " + ne.getMessage());
        }
        return res;
    }

    public Engine getEngine() throws CoreException {
        Engine res = null;
        try {
            Component engineComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            res = (Engine)engineComp.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    @Override
    public Process getProcess() throws CoreException {
        return this;
    }

    public Map<Endpoint, Map<String, ExternalContext>> getExternalContexts() {
        return this.externalContexts;
    }

    public ExternalContext getExternalContext(Endpoint serviceendpoint, String operation) {
        Map<String, ExternalContext> map = this.externalContexts.get(serviceendpoint);
        if (map != null) {
            return map.get(operation);
        }
        return null;
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public void end(boolean clean) throws CoreException {
        super.end(clean);
        this.setState(Process.State.PROCESS_ENDED);
        this.log.finest("PROCESS ENDED : " + this.getName());
        this.getMonitor().setEndTime(Calendar.getInstance().getTime());
        for (Map<String, ExternalContext> mapOperationContext : this.externalContexts.values()) {
            for (ExternalContext externalContext : mapOperationContext.values()) {
                if (externalContext == null || externalContext.getTerminationHandler() == null) continue;
                externalContext.getTerminationHandler().end((Scope)this);
            }
        }
    }

    public Process.State getState() {
        return this.state;
    }

    public void setState(Process.State state) {
        this.state = state;
    }

    @Override
    public String toString() {
        String res = super.toString();
        if (this.getName() != null) {
            res = this.getName();
        }
        return res;
    }

    public List<ProcessKey> getProcessKeys() {
        return this.keys;
    }

    public void setProcessKeys(List<ProcessKey> keys) {
        this.keys = keys;
    }

    public Assigner getAssigner() {
        return this.assigner;
    }

    public void setAssigner(Assigner assigner) {
        this.assigner = assigner;
    }

    public void addExternalContext(Endpoint serviceendpoint, String operation, ExternalContext context) {
        if (serviceendpoint != null && serviceendpoint.getServiceName() != null && serviceendpoint.getEndpointName() != null) {
            Map<String, ExternalContext> map = this.externalContexts.get(serviceendpoint);
            if (map == null) {
                map = new HashMap<String, ExternalContext>();
            }
            map.put(operation, context);
            this.externalContexts.put(serviceendpoint, map);
            this.log.finest("add external context ... " + this.externalContexts);
        }
    }

    public void removeExternalContext(Endpoint serviceendpoint, String operation) {
        Map<String, ExternalContext> map = this.externalContexts.get(serviceendpoint);
        if (map != null) {
            map.remove(operation);
            this.externalContexts.put(serviceendpoint, map);
        }
    }

    public void clearExternalContexts() {
        this.externalContexts.clear();
    }

    public Behaviour findBehaviour(String activityName) {
        Behaviour behaviour = null;
        try {
            String nodeName = "node_supporting_" + activityName;
            Node n = this.getNodeByName(nodeName);
            if (n != null) {
                Component c = (Component)SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), nodeName).get(0);
                SCAHelper.getSCAHelper().startComponent(c);
                Component cb = (Component)SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), activityName).get(0);
                SCAHelper.getSCAHelper().startComponent(cb);
                return n.getBehaviour();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (SCAException e) {
            e.printStackTrace();
        }
        return behaviour;
    }
}

