/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageAdapter;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={SenderBehaviour.class}, names={"service"})
public class SenderBehaviourImpl
extends AbstractBehaviourImpl
implements SenderBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(SenderBehaviourImpl.class.getName());
    @Property(name="kind", required=true)
    private SenderBehaviour.Kind kind;
    @Property(name="inputVariableName", required=true)
    private QName inputVariableName;
    @Property(name="outputVariableName", required=true)
    private QName outputVariableName;
    @Property(name="providerEndpointKey", required=false)
    private Object providerEndpointKey;
    @Property(name="operationName", required=false)
    private String operationName;
    @Property(name="messageAdapter", required=false)
    private MessageAdapter messageAdapter;
    @Property(name="faultHandler", required=false)
    private FaultHandler faultHandler;

    public String toString() {
        return "Sender Behaviour";
    }

    public void sendTo(InternalMessage<?> message, Endpoint endpoint, Map<Endpoint, Map<String, ExternalContext>> context) throws CoreException {
        Process p = this.getNode().getExecution().getParentScope().getProcess();
        p.getEngine().sendTo(message, endpoint, context);
    }

    public InternalMessage<?> sendSyncTo(InternalMessage<?> request, Endpoint endpoint, Map<Endpoint, Map<String, ExternalContext>> context) throws CoreException {
        Process p = this.getNode().getExecution().getParentScope().getProcess();
        return p.getEngine().sendSyncTo(request, endpoint, context);
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    public CorrelationMatcher getCorrelationMatcher() {
        return null;
    }

    public void setCorrelationMatcher(CorrelationMatcher correlationMatcher) {
    }

    protected void executeOnEnded() throws CoreException {
    }

    /*
     * Unable to fully structure code
     */
    protected void executeOnInactive() throws CoreException {
        this.log.finest("start sender behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        this.log.finest("execute sender behaviour on node: " + this.node.getName());
        this.log.finest("get the variable : " + this.inputVariableName);
        scope = this.node.getExecution().getParentScope();
        inputVariable = scope.findVariable(this.inputVariableName);
        if (inputVariable == null) {
            throw new CoreException("Input Variable " + this.inputVariableName + " not found in behaviour: " + this.getName());
        }
        if (this.kind == null) {
            throw new CoreException("Kind cannot be null");
        }
        if (this.providerEndpointKey != null) {
            providerEndpoint = scope.findEndpoint(this.providerEndpointKey);
            if (providerEndpoint == null) {
                throw new CoreException("Provider Endpoint cannot be null");
            }
            if (this.operationName != null) {
                providerEndpoint.setInvokedOperation(this.operationName);
            }
            this.log.finest("send message to " + providerEndpoint.getEndpointName() + " on interface " + providerEndpoint.getInterfaceName() + " on operation " + this.operationName);
            try {
                if (this.kind == SenderBehaviour.Kind.ASYNCHRONOUS) {
                    this.log.finest("asynchronous send");
                    outputMessage = inputVariable.getValue();
                    if (this.messageAdapter != null) {
                        outputMessage = this.messageAdapter.adapt(inputVariable);
                        this.log.finest("adapt the message: " + outputMessage);
                    }
                    outputMessage.setOperationName(providerEndpoint.getInvokedOperation());
                    this.sendTo(outputMessage, providerEndpoint, this.getNode().getExecution().getParentScope().getProcess().getExternalContexts());
                }
                if (this.kind != SenderBehaviour.Kind.SYNCHRONOUS) ** GOTO lbl50
                this.log.finest("synchronous send");
                outputVariable = scope.findVariable(this.outputVariableName);
                if (outputVariable == null) {
                    throw new CoreException("Output Variable " + this.outputVariableName + " not found in behaviour: " + this.getName());
                }
                outputMessage = inputVariable.getValue();
                if (this.messageAdapter != null) {
                    outputMessage = this.messageAdapter.adapt(inputVariable);
                    this.log.finest("adapt the message: " + outputMessage);
                }
                this.log.finest("operation name : " + this.operationName);
                outputVariable.setValue(this.sendSyncTo(outputMessage, providerEndpoint, this.getNode().getExecution().getParentScope().getProcess().getExternalContexts()));
            }
            catch (CoreException e) {
                this.state = Behaviour.State.ACTIVITY_ENDED;
                if (this.faultHandler != null) {
                    modelException = this.faultHandler.getModelExceptionFromGenericException(scope, (Exception)e);
                    if (modelException != null) {
                        throw modelException;
                    }
                    throw e;
                }
                this.log.warning("exception handler is null");
                throw e;
            }
        } else {
            this.log.finest("the provider Endpoint Key is null");
        }
lbl50:
        // 4 sources

        this.log.finest("Message accepted by the received activity: " + this.getName());
        this.state = Behaviour.State.ACTIVITY_ENDED;
    }

    protected void executeOnStarted() throws CoreException {
    }

    public void clean() {
        super.clean();
    }
}

