/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.engine;

import java.util.List;

import org.objectweb.fractal.fraclet.annotations.Interface;

import com.ebmwebsourcing.easyviper.core.api.CoreException;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Interface(name = "service")
public interface Execution extends Element {

	enum State {
		ACTIVE, INACTIVE, ENDED, CANCELLED, SUSPENDED
	};

	List<Execution> getChildExecutions();

	void addExecution(Execution execution) throws CoreException;

	void removeChildExecutions() throws CoreException;

	void removeChildExecution(Execution execution) throws CoreException;

	void run() throws CoreException;

	void runSlowly(long time) throws CoreException;

	void runStepByStep() throws CoreException;

	void signal() throws CoreException;

	void signal(Execution childExecution) throws CoreException;

	void end() throws CoreException;

	void setState(State state);
	
	void setStateRecursively(State state);

	State getState();

	Execution getParentExecution();

	Scope getParentScope() throws CoreException;

	void next() throws CoreException;

	void setSpeedTime(long time);

	long getSpeedTime();

	boolean isStepByStep();

	void setStepByStep(boolean stepByStep);

	ExecutableElement getCurrentTarget();
}
