/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.model;

import org.objectweb.fractal.fraclet.annotations.Interface;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Element;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.AbstractCompiler;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.Compiler;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinitionRegistry;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Interface(name = "service")
public interface Model extends Element {

	ProcessDefinitionRegistry<? extends ProcessDefinition> createRegistry(
			String name,
			Class<? extends AbstractProcessDefinitionRegistry> registryClass)
			throws CoreException;

	ProcessDefinitionRegistry<? extends ProcessDefinition> getRegistry()
			throws CoreException;

	Compiler createCompiler(String name,
			Class<? extends AbstractCompiler> compilerClass)
			throws CoreException;

	Compiler getCompiler() throws CoreException;

	Core getCore() throws CoreException;
}
