package com.ebmwebsourcing.easyviper.core.api.tools;

import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;

public class ProcessForker extends Thread {

	private int _threadId;
	private ProcessDefinition _process;
	private AbstractProcessDefinitionRegistry<ProcessDefinition> _registry;
	private List<ProcessKey> _keys;
	private Logger _log = Logger.getLogger(ProcessForker.class.getName());
	
	public ProcessForker(int threadId, ProcessDefinition process, AbstractProcessDefinitionRegistry registry, List<ProcessKey> keys){
		this._threadId = threadId;
		this._process = process;
		this._registry = registry;
		this._keys = keys;
	}

	public void run(){
		try{
			final Process processInstance = this._registry.getModel().getCompiler().compile(this._process);

			processInstance.run();
			this._log.finest("Process"+processInstance.getName()+" n°"+this._threadId+" successfully started.");
		}catch(CoreException e){
			this._log.severe(e.getMessage());
		}
	}
}
