/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.engine;

import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface Node extends SCAComponent {

	void setLog(Logger logger);
	
	void execute() throws CoreException;

	Execution getExecution();

	void selectDefaultNextTarget() throws CoreException;
	
	List<Node> getChildNodes();

	Node getParentNode();

	Behaviour getBehaviour();

	List<Node> getIncomingNodes();

	List<Node> getOutgoingNodes();
	
	Logger getLogger();
	
	void setExecution(Execution exec);
	
	void setActivity(Behaviour behaviour);

//	Map<String, Transition> getMapOutgoingTransitions();
//	List<Node> getMapOutgoingNodes();
	
//	Map<String, Transition> getMapIncomingTransitions();
//	List<Node> getMapIncomingNodes();
}
