/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink,
 * http://www.petalslink.com/
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easyviper.core.api.engine;

import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import com.ebmwebsourcing.easyviper.core.api.engine.monitoring.Monitor;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
//@Interface(name = "process")
public interface Process extends Scope {//,  WsnbNotificationProducer, WsnbSubscriptionManager {

	public enum State {
		PROCESS_INACTIVE, PROCESS_ACTIVE, PROCESS_ENDED, PROCESS_UNSTABLE
	};

	void run() throws CoreException;
	
	void runStepByStep() throws CoreException;

	Execution createParentExecution() throws CoreException;

	Map<String, Execution> getSuspendedExecutions() throws CoreException;

	Engine getEngine() throws CoreException;

	Assigner getAssigner();

	void setAssigner(Assigner assigner);


	//TODO LESBEGCONTEXT
	//void setExternalContext(ExternalContext context);
	
	Monitor getMonitor();

	State getState();

	void setState(State state);

	void setProcessKeys(List<ProcessKey> keys);

	List<ProcessKey> getProcessKeys();

	ExternalContext getExternalContext(Endpoint serviceendpoint, String operation);

	void addExternalContext(Endpoint serviceendpoint, String operation, ExternalContext context);

	Map<Endpoint, Map<String,ExternalContext>> getExternalContexts();

	void removeExternalContext(Endpoint serviceendpoint, String operation);
	
	void clearExternalContexts();
	
	Behaviour findBehaviour(String activityName);

}
