/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.engine;

import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.objectweb.fractal.api.Component;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.handler.TerminationHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
//@Interface(name = "scope")
public interface Scope extends Node {

	Execution createExecution(String execName) throws CoreException;

	Execution getParentExecution() throws CoreException;
	
	void setParentExecution(Component parentExecution);

	Node createNode(String nodeName, Behaviour behaviour)
			throws CoreException;

	boolean removeNode(Node node) throws CoreException;

	void deleteExecution(Execution execution) throws CoreException;

	void end(boolean clean) throws CoreException;

	void linkedBrotherNodes(Node sourceNode, Node targetNode) throws CoreException;
	
	void linkedChildNodeToParent(Node parentNode, Node childNode)
			throws CoreException;

	Node unlinkBrotherNodes(final Node sourceNode, final Node targetNode) throws CoreException;
	
	void linkedExecution2ExecutableElement(Execution exe,
			Node target) throws CoreException;

	void linkedExecutableElement2Execution(Node source,
			Execution exe) throws CoreException;
	
	void linkedNodeAndFunctionnalBehaviour(Node node, Behaviour behaviour) throws CoreException;
	
	void unlinkedNodeAndFunctionnalBehaviour(Node node, Behaviour behaviour) throws CoreException;	


	List<Node> getAllNodes() throws CoreException;
	
	List<Scope> getAllScopes() throws CoreException;


	Node getNodeByName(String name) throws CoreException;

	void stopAllExecutions() throws CoreException;

	Node getInitialNode() throws CoreException;

	void setInitialNode(Node initial) throws CoreException;

	Map<QName, Variable> getVariables();
	
	Map<Object, Endpoint> getEndpoints();
	
	
	
	List<CorrelationGroup> getCorrelationGroups();

	Variable findVariable(QName name) throws CoreException;
	
	<B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass) throws CoreException;
	

	
	Endpoint findEndpoint(final Object key) throws CoreException;
	
	Object findEndpointKey(final Endpoint edp);
	
	List<CorrelationGroup> findCorrelationGroups(String name) throws CoreException;

	void setVariable(Variable v) throws CoreException;

	Scope getParentScope() throws CoreException;

	Process getProcess() throws CoreException;
	
	void linkInitialNodeAndExecution() throws CoreException;
	
	void unlinkedNodeAndExecution(final Node targetNode, final Execution execution)	throws CoreException;
	
	Map<Fault, Scope> getExceptions();
	
	void setExceptions(Map<Fault, Scope> exceptions);
	
	Exception isFaultScope();
	
	void setFaultScope(Exception faultScope);
	
	void setTerminationHandler(TerminationHandler th);
	
	TerminationHandler getTerminationHandler();
}
