/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.engine.behaviour;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=Behaviour.class,names="abstract_service")
@PolicySets("frascati:scaEasyPrimitive")
public abstract class AbstractBehaviourImpl extends SCAComponentImpl implements Behaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(AbstractBehaviourImpl.class.getName());

	protected State state = State.ACTIVITY_INACTIVE;

	@Reference(name="node",required=false)
	protected Node node;


	public QName getQName() throws CoreException {
		QName res = QName.valueOf(this.getName());
		return res;
	}

	public void setQName(QName name) throws CoreException {
		this.setName(name.toString());
	}


	protected abstract void executeOnInactive() throws CoreException;

	protected abstract void executeOnStarted() throws CoreException;

	protected abstract void executeOnEnded() throws CoreException;


	public void execute() throws CoreException {
		// TODO : it *seems* that this is used mostly for loop behaviours.
		// this transition corresponds to a reuse of the node, we should reset activity state
		// to inactive only when it is necessary 
		if (this.state == State.ACTIVITY_ENDED) {
			this.log.finest("restart the " + this.getName() + " activity");
			this.state = State.ACTIVITY_INACTIVE;
		}

		

		this.log.finest("execute the " + this.getName() + " activity on node ("
				+ this.getNode().getName() + ") by execution ("
				+ this.getNode().getExecution().getName() + ")");

		if (state == State.ACTIVITY_INACTIVE) {
			executeOnInactive();
		} else if (state == State.ACTIVITY_STARTED) {
			executeOnStarted();
		} else if (state == State.ACTIVITY_ENDED) {
			executeOnEnded();
		}

	}

	public Node getNode() {
		return this.node;
	}


	@Override
	public String toString() {
		String res = "";
		res = "behaviour " + this.getName() + " on Node "
		+ this.getNode().getName();
		return res;
	}

	public State getState() {
		return this.state;
	}

	public void setState(final State state) {
		this.state = state;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}



}
