/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.engine.behaviour;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface Behaviour extends SCAComponent {

	public enum State {
		ACTIVITY_INACTIVE, ACTIVITY_STARTED, ACTIVITY_ENDED
	};


	void execute() throws CoreException;


	Node getNode();

	State getState();

	void setState(State state);
	
	QName getQName() throws CoreException;
	
	void setQName(QName name) throws CoreException;
	
	void setLog(Logger logger);
}
